//https://splidejs.com/guides/options/#options
class SliderHandler {
    constructor(config) {
        this.defaultConfig = {};
        this.defaultConfig.mainSelectorClassName = "ig-splide-slider";
        this.splideSliders = document.getElementsByClassName(this.defaultConfig.mainSelectorClassName);
        this.sliders = [];
        this.config = { ...this.defaultConfig, ...config };
        this.init();
        this.tempSettings = {};
    }
    init() {
        for (let i = 0; i < this.splideSliders.length; i++) {
            this.splideSliders[i].splideInstance = this.generateSlider(this.splideSliders[i]);
            this.sliders.push(this.splideSliders[i].splideInstance);
        }
    }
    generateSlider(slider, isThumbnails = false) {
        let splide;
        let settings = {};
        let thumbnails = null;
        settings = JSON.parse(slider.dataset.settings) || {};
        // only filled when thumbnails active
        if (this.tempSettings) {
            settings = { ...this.tempSettings, ...settings };
        }

        if (settings.asNavFor && !isThumbnails) {
            let thumbnailElement = document.querySelector(settings.asNavFor);
            this.tempSettings = settings;
            thumbnails = this.generateSlider(thumbnailElement, true);
        }

        // dots
        if (!settings.pagination && !settings.useDots) {
            settings.pagination = false;
        }
        // arrows
        if (!settings.arrows && !settings.useArrows) {
            settings.arrows = false;
        }
        // swipe/draggable
        if (!settings.drag && !settings.draggable) {
            // FS: default off?
            // settings.drag = false;
            if (settings.swipe) {
                settings.drag = settings.swipe;
            }
        }
        // fallback start slide
        if (!settings.start && settings.initialSlide) {
            settings.start = settings.initialSlide;
        }

        // fallback type
        if (!settings.type && settings.fade) {
            settings.type = "fade";
        }
        // fallback items per page
        if (!settings.perPage && settings.slidesToShow) {
            settings.perPage = parseInt(settings.slidesToShow);
        }
        // fallback autoplay speed
        if (!settings.interval && (settings.autoplaySpeed)) {
            settings.interval = settings.autoplaySpeed;
        }
        // fallback speed
        if (!settings.speed || settings.speedSec) {
            settings.speed = settings.speed || settings.speedSec * 1000 || 2000;
        }
        // fallback autoHeight
        if (!settings.autoHeight && settings.adaptiveHeight) {
            settings.autoHeight = settings.adaptiveHeight;
        }
        // randomFirst
        if (!settings.start && settings.randomFirst) {
            let slides = slider.getElementsByClassName("splide__list")[0];
            settings.start = Math.floor(Math.random() * slides.children.length);
        }
        // does not change ID and classes
        if (settings.random) {
            let slides = slider.getElementsByClassName("splide__list")[0],
                temp = slides.cloneNode(true);
            for (let i = temp.children.length + 1; i--;) {
                temp.appendChild(temp.children[(Math.random() * i) | 0]);
            }
            slides.parentNode.replaceChild(temp, slides);
        }

        // FS: refine this
        settings.video = {
            autoplay: true,
            mute: true,
        };
        // when thumbnails force override settings
        // if (thumbnails) {
        //     settings.pagination = false;
        //     settings.arrows = false;
        // }
        if (isThumbnails) {
            // let arrowPath = settings.arrowPath;
            let thumbnailsSettings = {};
            thumbnailsSettings.type = settings.type || 'slide';
            thumbnailsSettings.fixedWidth = settings.fixedWidth || 60;
            thumbnailsSettings.fixedHeight = settings.fixedHeight || 60;
            thumbnailsSettings.gap = settings.gap || 2;
            thumbnailsSettings.pagination = settings.pagination || false;
            thumbnailsSettings.trimSpace = settings.trimSpace || false;
            thumbnailsSettings.focus = settings.focus || "center";
            thumbnailsSettings.isNavigation = true;
            // thumbnailsSettings.arrowPath = arrowPath;
            settings = { ...settings, ...thumbnailsSettings };
        }
        settings.rewind = (typeof settings.rewind !== 'undefined') ? settings.rewind : true;
        splide = new Splide(slider, settings);
        if (!isThumbnails) {
            // check if active slide has a video
            splide.on("active", (Slide) => {
                let slide = Slide.slide;
                let Autoplay = splide.Components.Autoplay;
                if (slide.classList.contains("splide__slide--has-video")) {
                    Autoplay.pause();
                } else {
                    // if video skipped
                    if (settings.autoplay) Autoplay.play();
                }
            });
            splide.on("video:ended", () => {
                let Autoplay = splide.Components.Autoplay;
                if (settings.autoplay) Autoplay.play();
            });
        }
        // sync slider with thumbnails
        if (thumbnails && thumbnails.slider) {
            splide.sync(thumbnails.slider);
        }
        if (window.splide && window.splide.Extensions) {
            splide.mount(window.splide.Extensions);
        } else {
            splide.mount();
        }
        let sliderAndConfig = {};
        sliderAndConfig.slider = splide;
        if (thumbnails && thumbnails.slider) {
            // force thumbnails active class while transition
            thumbnails.slider.on('move', (newIndex) => {
                let allSlides = thumbnails.slider.root.querySelectorAll('.splide__slide');
                allSlides?.forEach(slide => {
                    slide.classList.remove('is-active');
                });
                let slide = thumbnails.slider.root.querySelector('[data-splide-index="slide' + newIndex + '"]');
                slide.classList.add('is-active');
            });
            sliderAndConfig.thumbnails = thumbnails;
        }
        sliderAndConfig.settings = settings;

        return sliderAndConfig;
    }
    debug() {
        console.log(this.sliders);
    }
}
let sliderHandler = null;
document.addEventListener("DOMContentLoaded", () => {
    sliderHandler = new SliderHandler();
});

// type
// role
// label
// labelledby
// rewind
// rewindSpeed
// rewindByDrag
// width
// height
// fixedWidth
// fixedHeight
// heightRatio
// autoWidth
// autoHeight
// start
// perPage
// perMove
// clones
// cloneStatus
// focus
// gap
// padding
// arrows
// pagination
// paginationKeyboard
// paginationDirection
// easing
// easingFunc
// drag
// snap
// noDrag
// dragMinThreshold
// flickPower
// flickMaxPages
// waitForTransition
// arrowPath
// autoplay
// interval
// pauseOnHover
// pauseOnFocus
// resetProgress
// lazyLoad
// preloadPages
// keyboard
// wheel
// wheelMinThreshold
// wheelSleep
// releaseWheel
// direction
// cover
// slideFocus
// focusableNodes
// isNavigation
// trimSpace
// omitEnd
// updateOnMove
// mediaQuery
// live
// breakpoints
// reducedMotion
// classes
// i18b
// destroy
