<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

// macht aktuell keinen Sinn
class AspectViewHelper extends AbstractViewHelper
{
    public function initializeArguments()
    {
        $this->registerArgument('name', 'string', '', true);
        $this -> registerArgument('as', 'string', 'Name for the frontendUser object', false, 'frontendUser');
    }

    /**
     *  many properties are protected :-(
     * viewhelper will cached, don't use it for e.g. frontend users!
     *
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
  {
        $templateVariableContainer=$renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], GeneralUtility::makeInstance(Context::class)->getAspect($arguments['name']));
        $content = $renderChildrenClosure();
        $templateVariableContainer->remove($arguments['as']);
        return $content;
    }
}
