<?php
namespace Internetgalerie\IgRender\ViewHelpers\Format;


use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithContentArgumentAndRenderStatic;


class DateViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Format\DateViewHelper
{
    use CompileWithContentArgumentAndRenderStatic;

    /**
     * Initialize arguments
     */
    public function initializeArguments():void
    {
        parent::initializeArguments();
        $this->registerArgument('locale', 'string', 'Locale to use');        
    }


    /**
     * Output is escaped already. We must not escape children, to avoid double encoding.
     *
     * @var bool
     */
    protected $escapeChildren = false;

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     *
     * @return string
     * @throws Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext):string
    {

            // numeric locale is not set by the core because of problems with floats, set it here manually for number format:
            $currentLocale = setlocale(LC_TIME, 0);
            if (isset($arguments['locale'])) {
                setlocale(LC_TIME, $arguments['locale']);
            }
            $ret = parent::renderStatic($arguments, $renderChildrenClosure, $renderingContext);
            setlocale(LC_TIME, $currentLocale);
            return $ret;
    }
}
