<?php

namespace Internetgalerie\IgRender\ViewHelpers\Media;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class PosterViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('uid', 'int', 'FileReference', true);
        $this->registerArgument('as', 'string', 'assign variable', false, 'poster');
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('sys_file_reference');
        $result = $queryBuilder
            ->select('s.uid')
            ->from('sys_file_reference')
            ->join(
                'sys_file_reference',
                'sys_file',
                's',
                $queryBuilder->expr()->eq('uid_local', $queryBuilder->quoteIdentifier('s.uid'))
            )
            ->where(
                $queryBuilder->expr()->eq('uid_foreign', $queryBuilder->createNamedParameter($arguments['uid'], Connection::PARAM_INT)),
                $queryBuilder->expr()->eq('tablenames', $queryBuilder->createNamedParameter('sys_file_reference'))
            )
            ->executeQuery()->fetchAllAssociative();
        if (count($result) > 0) {
            $resourceFactory = GeneralUtility::makeInstance(\TYPO3\CMS\Core\Resource\ResourceFactory::class);
            // prepared for multiple files
            $files = [];
            foreach ($result as $key => $r) {
                $files[] = $resourceFactory->getFileObject($r['uid']);
            }
            $templateVariableContainer = $this->renderingContext->getVariableProvider();
            $templateVariableContainer->add($arguments['as'], $files);
            $output = $this->renderChildren();
            $templateVariableContainer->remove($arguments['as']);
            return $output;
        }
        return '';
    }
}
