<?php
header('Content-Type: text/html; charset=UTF-8');
$preEn = '<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xliff version="1.0">
	<file source-language="en" datatype="plaintext" original="messages" date="2014-11-12T13:49:32Z">
		<header>
			<generator>DataPoolLfGenerator</generator>
		</header>
		<body>';

$preNormal = '<?xml version="1.0" encoding="utf-8" standalone="yes" ?>
<xliff version="1.0">
	<file source-language="en" target-language="###TARGETLANG###" datatype="plaintext" original="messages" date="2014-11-12T13:49:32Z">
		<header>
			<generator>DataPoolLfGenerator</generator>
		</header>
		<body>';

$lineEn = '
<trans-unit id="###KEY###" xml:space="preserve">
	<source>###VALUE###</source>
</trans-unit>
';

$lineLang = '
<trans-unit id="###KEY###" approved="yes" xml:space="preserve">
	<source>###VALUEEN###</source>
	<target>###VALUE###</target>
</trans-unit>';

$after = '
		</body>
	</file>
</xliff>';

function getline($arg) {
	//$arg = mb_convert_encoding($arg, "UTF-8", "UTF-16");

	return str_getcsv($arg, ",", '""', '\\');
}

$arr = array_map('getline', file('labels.csv'));
$langs = array_shift($arr);
unset($langs[0]);

$newArr = array();
foreach ($arr as $row => $elems) {
	if (!$elems[0])
		continue;
	for ($i = 1; $i <= count($langs); $i++) {
		$newArr[$elems[0]][$langs[$i]] = $elems[$i];
	}
}

$result = array();
foreach ($langs as $lang) {
	if ($lang == 'en') {
		$result[$lang] = $preEn;
	} else {
		$result[$lang] = str_replace('###TARGETLANG###', $lang, $preNormal);
	}
}
foreach ($newArr as $key => $values) {
	if (!$key)
		continue;
	foreach ($langs as $lang) {
		if ($values[$lang] == '')
			$values[$lang] = 'MISSING LABEL: ' . $key;
		if ($lang == 'en') {
			$result[$lang] .= str_replace(array('###KEY###', '###VALUE###'), array($key, $values[$lang]), $lineEn);
		} else {

			$result[$lang] .= str_replace(array('###KEY###', '###VALUE###', '###VALUEEN###'), array($key, $values[$lang], $values['en']), $lineLang);
		}
	}

}

foreach ($langs as $lang) {
	$result[$lang] .= $after;
}
?>
<html>
    <head>
        <title>XLFgen</title>
    </head>
    <body>
        <?php

foreach ($result as $key=>$val){
        ?>
        <?php echo $key; ?>
        <br />
        <textarea style="width:100%;height:300px;"><?php echo htmlspecialchars($val); ?></textarea>                                                                                                                                                
		
 <?php
$filename = $key == 'en' ? 'locallang.xlf' : $key . '.locallang.xlf';
file_put_contents('../Private/Language/'.$filename, $val);
}
        ?>
    </body>
</html>