<?php

namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Slider
 */
class SliderViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('classname', 'string', 'Classname - should be unique', false, '');
        $this->registerArgument('class', 'string', 'Class', false, '');
        $this->registerArgument('id', 'string', 'Id - should be unique', false, '');
        $this->registerArgument('settings', 'array', 'settings - as array see https://kenwheeler.github.io/slick/#settings', false, []);
        $this->registerArgument('settingsJs', 'array', 'settings - as array see https://kenwheeler.github.io/slick/#settings', false, []);
        $this->registerArgument('settingsName', 'string', 'Name für Extra TypoScript settings', false, 'default');
        $this->registerArgument('config', 'string', 'Slider Cofig: slick,lightslider,splide', false, 'default');
        $this->registerArgument('aspect', 'string', 'Aspect String', false, '16-9');
        $this->registerArgument('fade', 'bool', 'fade on/off', false);
        $this->registerArgument('swipe', 'bool', 'swipe on/off', false);
        $this->registerArgument('slidesToShow', 'int', 'slide to show', false, 1);
        $this->registerArgument('initialSlide', 'string', 'slide to start', false, '0');
        $this->registerArgument('useHash', 'bool', 'if a hash in present in url, the slide with this hash is used as initialSlide, otherwise initialSlide is shown', false);
        $this->registerArgument('autoplay', 'bool', 'autoplay on/off', false);
        $this->registerArgument('autoplaySpeed', 'string', 'autoplaySpeed in ms', false);
        $this->registerArgument('autoplaySpeedSec', 'string', 'autoplaySpeed in Sekunden', false);
        $this->registerArgument('speed', 'string', 'speed in ms', false);
        $this->registerArgument('speedSec', 'string', 'speed in Sekunden', false);
        //$this->registerArgument('asNavFor', 'string', 'Navigation for', false); // Slicke
        $this->registerArgument('random', 'bool', 'Random image order', false);
        $this->registerArgument('randomFirst', 'bool', 'Choose random first image', false);
        $this->registerArgument('slidesAmount', 'int', 'The amount of slides there are', false);
        $this->registerArgument('useAutoplayToggleButton', 'bool', 'Controls whether a pause/play icon button is added when autoplay is enabled. Setting this to false without providing an alternative control would likely violate WCAG 2.2.2, so be careful!', false, false);
        $this->registerArgument('useArrows', 'bool', 'Enable Next/Prev arrows', false, false);
        $this->registerArgument('useDots', 'bool', 'Enable dots', false, false);
        $this->registerArgument('output', 'string', 'Output mode (default, simple)', false, 'default');
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $renderChildrenClosure = $this->buildRenderChildrenClosure();
        $renderingContext = $this->renderingContext;
        $slidesToShow = $arguments['slidesToShow'];
        $initialSlide = $arguments['initialSlide'];
        $slidesAmount = (int) $arguments['slidesAmount'];
        $id = $arguments['id'];
        $additionalClass = '';

        // check initialSlide for allowed values
        $initialSlide = \Internetgalerie\IgRender\Utility\SliderConfigUtility::checkInitialSlide($initialSlide);

        $selectedConfig = \Internetgalerie\IgRender\Utility\SliderConfigUtility::get($arguments);
        $viewHelperVariableContainer = $renderingContext->getViewHelperVariableContainer();
        // is the slicer inside another slider
        $backupSliderIndex = null;
        $backupSlidesToShow = null;
        $backupInitialSlide = null;
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex')) {
            $backupSliderIndex = (int)$viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex');
        }
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow')) {
            $backupSlidesToShow = (int)$viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow');
        }
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide')) {
            $backupInitialSlide = $viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide');
        }
        $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex', 0);
        $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow', $slidesToShow);
        $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide', $initialSlide);

        $childOutput = $renderChildrenClosure();
        $sliderIndex = (int) $viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex');
        if ($backupSliderIndex !== null) {
            $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex', $backupSliderIndex);
            $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow', $backupSlidesToShow);
            $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide', $backupInitialSlide);
        } else {
            $viewHelperVariableContainer->remove(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex');
            $viewHelperVariableContainer->remove(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow');
            $viewHelperVariableContainer->remove(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide');
        }

        if ($slidesAmount > $slidesToShow) {
            $additionalClass = ' slider-centerMode ';
        }

        if ($initialSlide === 'last') {
            $selectedConfig['dataSettings']['initialSlide'] = $sliderIndex - 1;
        }
        //var_dump($sliderIndex, $selectedConfig['dataSettings']);exit(0);
        if (!empty($childOutput)) {
            $data = 'data-settings="' . htmlspecialchars(json_encode($selectedConfig['dataSettings'])) . '"';
            $data .= ' data-number-of-slides="' . $slidesToShow . '"';
            if ($arguments['aspect']) {
                $data .= ' data-aspect="' . $arguments['aspect'] . '"';
            }
            if ($arguments['random']) {
                $data .= ' data-shuffle="1"';
            }

            if ($arguments['output'] == 'simple') {
                return '<' . $selectedConfig['sliderTag'] . ($id ? ' id="' . $id . '"' : '') . ' class="splide ig-slider ig-slider-' . $slidesToShow . '-slides-to-show ' . $selectedConfig['classname'] . ($arguments['class'] ? ' ' . $arguments['class'] : '') . ' ig-slider-onload' . $additionalClass . '" ' . $data . '>' . $childOutput . '</' . $selectedConfig['sliderTag'] . '>';
            }

            return '<' . $selectedConfig['sliderTag'] . ($id ? ' id="' . $id . '"' : '') . ' class="splide ig-slider ig-slider-' . $slidesToShow . '-slides-to-show ' . $selectedConfig['classname'] . ($arguments['class'] ? ' ' . $arguments['class'] : '') . ' ig-slider-onload' . $additionalClass . '" ' . $data . '>' . $selectedConfig['slideContainerStart'] . $childOutput . $selectedConfig['slideContainerStop'] . ($arguments['useArrows'] ? ' ' . $selectedConfig['sliderArrowsHtml'] : '') . '</' . $selectedConfig['sliderTag'] . '>';
        } else {
            return '';
        }
    }
}
