<?php

namespace Ig\IgReservations\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Ig\IgReservations\Domain\Repository\FeUserRepository;
use TYPO3\CMS\Extbase\Annotation\Validate;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Ig\IgReservations\Domain\Model\FeUser;
use Ig\IgReservations\Service\MailService;
use Ig\IgReservations\Service\UserService;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * EventController
 */
class FeUserController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * feUserRepository
     *
     * @var FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * MailService
     *
     * @var MailService
     */
    protected $mailService = null;

    /**
     * @var \Ig\IgReservations\Domain\Service\UserService
     */
    protected UserService $userService;

    
    public function injectFeUserRepository(
        FeUserRepository $feUserRepository
    ): void {
        $this->feUserRepository = $feUserRepository;
    }


    public function injectMailService(MailService $mailService): void
    {
        $this->mailService = $mailService;
    }

    public function injectUserService(UserService $userService): void
    {
        $this->userService = $userService;
    }

    public function initializeAction(): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addCssFile('EXT:ig_reservations/Resources/Public/Lib/jquery-confirm/jquery-confirm.min.css');
        $pageRenderer->addCssFile('EXT:ig_reservations/Resources/Public/Css/ig_reservations.scss');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/Lib/jquery-confirm/jquery-confirm.min.js');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/JavaScript/ConfirmDelete.js');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/JavaScript/ig_reservations.js');
        $this->mailService->setSettings($this->settings);
        $this->mailService->setRequest($this->request);
    }

    public function managementListAction(): ResponseInterface
    {
        $users = $this->feUserRepository->findTeammembers($this->settings['usergroupForTeammembers'] ?: 0);
        $this->view->assign('users', $users);

        return $this->htmlResponse();
    }

    
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    #[Validate(['validator' => DynamicValidator::class, 'param' => 'newFeUser'])]
    public function createAction(FeUser $newFeUser): ResponseInterface
    {
        $this->feUserRepository->add($newFeUser);
        return $this->redirect('list');
    }

    
    public function editAction(FeUser $feUser): ResponseInterface
    {
        $this->view->assign('feUser', $feUser);
        return $this->htmlResponse();
    }

    #[Validate(['validator' => DynamicValidator::class, 'param' => 'feUser'])]
    public function updateAction(FeUser $feUser): ResponseInterface
    {
        $this->feUserRepository->update($feUser);
        return $this->redirect('list');
    }

    
    public function deleteAction(FeUser $feUser): ResponseInterface
    {
        $this->feUserRepository->remove($feUser);
        return $this->redirect('list');
    }

    protected function initializeView($view): void
    {
        $user = $this->userService->getUser();
        $view->assign('user', $user);
    }
}
