<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Annotation\Validate;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * Address
 */
class Address extends AbstractEntity
{
    #[Validate(['validator' => 'NotEmpty'])]
    protected int $salutation = 0;

    #[Validate(['validator' => 'NotEmpty'])]
    protected string $firstName = '';

    #[Validate(['validator' => 'NotEmpty'])]
    protected string $lastName = '';

    protected string $company = '';

    #[Validate(['validator' => 'NotEmpty'])]
    protected string $address = '';

    #[Validate(['validator' => 'NotEmpty'])]
    protected string $zip = '';

    #[Validate(['validator' => 'NotEmpty'])]
    protected string $city = '';

    #[Validate(['validator' => 'NotEmpty'])]
    #[Validate(['validator' => 'EmailAddress'])]
    protected string $email = '';

    protected string $phone = '';

    /**
     * Returns the firstName
     *
     * @return string
     */
    public function getFirstName(): string
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     */
    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the lastName
     *
     * @return string
     */
    public function getLastName(): string
    {
        return $this->lastName;
    }

    /**
     * Sets the lastName
     */
    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    /**
     * Returns the company
     *
     * @return string
     */
    public function getCompany(): string
    {
        return $this->company;
    }

    /**
     * Sets the company
     */
    public function setCompany(string $company): void
    {
        $this->company = $company;
    }

    /**
     * Returns the address
     *
     * @return string
     */
    public function getAddress(): string
    {
        return $this->address;
    }

    /**
     * Sets the address
     */
    public function setAddress(string $address): void
    {
        $this->address = $address;
    }

    /**
     * Returns the zip
     *
     * @return string
     */
    public function getZip(): string
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     */
    public function setZip(string $zip): void
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string
     */
    public function getCity(): string
    {
        return $this->city;
    }

    /**
     * Sets the city
     */
    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    /**
     * Returns the email
     *
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * Sets the email
     */
    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * Returns the phone
     *
     * @return string
     */
    public function getPhone(): string
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     */
    public function setPhone(string $phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Returns the salutation
     *
     * @return int
     */
    public function getSalutation(): int
    {
        return $this->salutation;
    }

    /**
     * Sets the salutation
     */
    public function setSalutation(int $salutation): void
    {
        $this->salutation = $salutation;
    }
}
