<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use DateTime;

/**
 * BlockingTime
 */
class BlockingTime extends AbstractEntity
{
    /**
     * startDate
     */
    protected ?DateTime $startDate = null;

    /**
     * startTime
     *
     * @var string
     */
    protected $startTime = 0;

    /**
     * endDate
     *
     * @var DateTime
     */
    protected $endDate = null;

    /**
     * endTime
     *
     * @var string
     */
    protected $endTime = 0;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * calendar
     *
     * @var Calendar
     */
    protected $calendar = null;

    /**
     * Returns the startDate
     *
     * @return DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Sets the startDate
     */
    public function setStartDate(DateTime $startDate): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the startTime
     *
     * @return string
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    public function getStartTimeFormat()
    {
        return substr($this->startTime, 0, 5);
    }

    public function getStartDateTime()
    {
        if ($this->startDate) {
            return new DateTime($this->getStartDate()->format('Y-m-d') . 'T' . ($this->startTime ?: '00:00:00'));
        }
        return null;
    }

    /**
     * Sets the startTime
     */
    public function setStartTime(string $startTime): void
    {
        $this->startTime = $startTime;
    }

    /**
     * Returns the endDate
     *
     * @return DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Sets the endDate
     */
    public function setEndDate(DateTime $endDate): void
    {
        $this->endDate = $endDate;
    }

    /**
     * Returns the endTime
     *
     * @return string
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    public function getEndTimeFormat()
    {
        return substr($this->endTime, 0, 5);
    }

    public function getEndDateTime()
    {
        if ($this->endDate) {
            return new DateTime($this->getEndDate()->format('Y-m-d') . 'T' . ($this->startTime ?: '00:00:00'));
        }
        return null;
    }


    public function getStartEndDateTime()
    {
        $ret = $this->getStartDate()
->format('d.m.Y') . ' ' . $this->getStartTimeFormat() . ' - ';
        $ret .= ($this->getStartDate() != $this->getEndDate() ? $this->getEndDate()->format(
            'd.m.Y'
        ) . ' ' : '') . $this->getEndTimeFormat();
        return $ret;
    }


    /**
     * Sets the endTime
     */
    public function setEndTime(string $endTime): void
    {
        $this->endTime = $endTime;
    }


    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the calendar
     *
     * @return Calendar
     */
    public function getCalendar()
    {
        return $this->calendar;
    }

    /**
     * Sets the calendar
     */
    public function setCalendar(Calendar $calendar): void
    {
        $this->calendar = $calendar;
    }
}
