<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * BookingType
 */
class BookingType extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * isDefault
     *
     * @var bool
     */
    protected $isDefault = false;

    protected int $pageUid = 0;

    protected ObjectStorage $purposes;

    public function __construct()
    {
        $this->purposes = new ObjectStorage();
        //Do not remove the next line: It would break the functionality
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the isDefault
     *
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }

    /**
     * Sets the isDefault
     *
     * @param bool $isDefault
     */
    public function setIsDefault($isDefault): void
    {
        $this->isDefault = $isDefault;
    }

    /**
     * Returns the boolean state of isDefault
     *
     * @return bool
     */
    public function isIsDefault()
    {
        return $this->isDefault;
    }


    /**
     * Get the value of pageUid
     */
    public function getPageUid(): int
    {
        return $this->pageUid;
    }

    /**
     * Set the value of pageUid
     *
     * @param int $pageUid
     *
     * @return self
     */
    public function setPageUid($pageUid): void
    {
        $this->pageUid = $pageUid;
    }

    /**
     * Get the value of Purpose
     *
     * @return ObjectStorage<Purpose>
     */
    public function getPurposes()
    {
        return $this->purposes;
    }

    /**
     * Get the value of Purpose
     *
     * @return string
     */
    public function getPurposesCommaSeparated()
    {
        $list = '';
        $i = 0;
        foreach ($this->getPurposes() as $purpose) {
            if ($i > 0) {
                $list .= ',';
            }
            $list .= (string)$purpose->getUid();
            $i++;
        }

        return $list;
    }

    /**
     * Set the value of Purposes
     *
     * @param ObjectStorage<Purpose> $purposes
     *
     * @return self
     */
    public function setPurposes(ObjectStorage $purposes)
    {
        $this->purposes = $purposes;

        return $this;
    }

    /**
     * Adds a Purpose
     */
    public function addPurpose(Purpose $purpose): void
    {
        $this->purposes->attach($purpose);
    }

    /**
     * Removes a Purpose
     */
    public function removePurpose(Purpose $purposeToRemove): void
    {
        $this->purposes->detach($purposeToRemove);
    }
}
