<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * CalendarGroup
 */
class CalendarGroup extends AbstractEntity
{
    /**
     * name
     * @var string
     */
    protected $name = '';

    /**
     * calendars
     *
     * @var ObjectStorage<Calendar>
     */
    protected $calendars = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Adds a Calendar
     */
    public function addCalendar(Calendar $calendar): void
    {
        $this->calendars->attach($calendar);
    }

    /**
     * Removes a Calendar
     *
     * @param Calendar $calendarToRemove The Calendar to be removed
     */
    public function removeCalendar(Calendar $calendarToRemove): void
    {
        $this->calendars->detach($calendarToRemove);
    }

    /**
     * Returns the calendars
     *
     * @return ObjectStorage<Calendar> $calendars
     */
    public function getCalendars()
    {
        return $this->calendars;
    }

    /**
     * Sets the calendars
     *
     * @param ObjectStorage<Calendar> $calendars
     */
    public function setCalendars(ObjectStorage $calendars): void
    {
        $this->calendars = $calendars;
    }



    /**
     * Get the value of name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set the value of name
     *
     * @param string $name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->calendars = new ObjectStorage();
    }
}
