<?php

namespace Ig\IgReservations\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * FeUser
 */
class FeUser extends FrontendUser
{
    /**
     * gender
     * @var int
     */
    protected $gender = 0;

    protected ObjectStorage $purposes;

    public function __construct()
    {
        $this->purposes = new ObjectStorage();
        //Do not remove the next line: It would break the functionality
    }

    public function getUsernameAndName()
    {
        return $this->firstName . ' ' . $this->lastName . ' (' . $this->username . ')';
    }

    /**
     * Get the value of gender
     *
     * @return int
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Set the value of gender
     *
     * @param int $gender
     *
     * @return self
     */
    public function setGender($gender)
    {
        $this->gender = $gender;

        return $this;
    }

    /**
     * Get the value of Purpose
     *
     * @return ObjectStorage<Purpose>
     */
    public function getPurposes()
    {
        return $this->purposes;
    }

    /**
     * Set the value of Purposes
     *
     * @param ObjectStorage<Purpose> $purposes
     *
     * @return self
     */
    public function setPurposes(ObjectStorage $purposes)
    {
        $this->purposes = $purposes;

        return $this;
    }

    /**
     * Adds a Purpose
     */
    public function addPurpose(Purpose $purpose): void
    {
        $this->purposes->attach($purpose);
    }

    /**
     * Removes a Purpose
     */
    public function removePurpose(Purpose $purposeToRemove): void
    {
        $this->purposes->detach($purposeToRemove);
    }

    /**
     * Get the value of Purpose
     *
     * @return string
     */
    public function getPurposesCommaSeparated()
    {
        $list = '';
        $i = 0;
        foreach ($this->getPurposes() as $purpose) {
            if ($i > 0) {
                $list .= ',';
            }
            $list .= (string)$purpose->getUid();
            $i++;
        }

        return $list;
    }
}
