<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use DateTime;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <typo3@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * Restriction
 */
class Restriction extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * weekday
     *
     * @var int
     */
    protected $weekday = 0;

    /**
     * holiday
     *
     * @var bool
     */
    protected $holiday = false;

    /**
     * fromDate
     *
     * @var DateTime
     */
    protected $fromDate = null;

    /**
     * toDate
     *
     * @var DateTime
     */
    protected $toDate = null;

    /**
     * Returns the weekday
     *
     * @return int
     */
    public function getWeekday()
    {
        return $this->weekday;
    }

    /**
     * Sets the weekday
     *
     * @param int $weekday
     */
    public function setWeekday($weekday): void
    {
        $this->weekday = $weekday;
    }

    /**
     * Returns the holiday
     *
     * @return bool
     */
    public function getHoliday()
    {
        return $this->holiday;
    }

    /**
     * Sets the holiday
     *
     * @param bool $holiday
     */
    public function setHoliday($holiday): void
    {
        $this->holiday = $holiday;
    }

    /**
     * Returns the boolean state of holiday
     *
     * @return bool
     */
    public function isHoliday()
    {
        return $this->holiday;
    }

    /**
     * Returns the fromDate
     *
     * @return DateTime
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }

    /**
     * Sets the fromDate
     */
    public function setFromDate(DateTime $fromDate): void
    {
        $this->fromDate = $fromDate;
    }

    /**
     * Returns the toDate
     *
     * @return DateTime
     */
    public function getToDate()
    {
        return $this->toDate;
    }

    /**
     * Sets the toDate
     */
    public function setToDate(DateTime $toDate): void
    {
        $this->toDate = $toDate;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }
}
