<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * Timeslot
 */
class Timeslot extends AbstractEntity
{
    /**
     * startTime
     *
     * @var string
     */
    protected $startTime = 0;

    /**
     * endTime
     *
     * @var string
     */
    protected $endTime = 0;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * Returns the startTime
     *
     * @return string
     */
    public function getStartTime()
    {
        return $this->startTime;
    }

    /**
     * Sets the startTime
     */
    public function setStartTime(string $startTime): void
    {
        $this->startTime = $startTime;
    }
    public function getStartTimeInt()
    {
        $parts = explode(':', $this->startTime);
        return $parts[0] * 3600 + $parts[1] * 60 + $parts[2];
    }

    /**
     * Returns the endTime
     *
     * @return string
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    public function getEndTimeInt()
    {
        $parts = explode(':', $this->endTime);
        return $parts[0] * 3600 + $parts[1] * 60 + $parts[2];
    }

    /**
     * Sets the endTime
     */
    public function setEndTime(string $endTime): void
    {
        $this->endTime = $endTime;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }
}
