<?php

namespace Ig\IgReservations\ViewHelpers\Calendar;

use Ig\IgReservations\Domain\Model\Calendar;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IsAdminViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('calendar', Calendar::class, 'Calendar for ACL', true);
    }

    /**
     * Static method which can be overridden by subclasses. If a subclass
     * requires a different (or faster) decision then this method is the one
     * to override and implement.
     *
     * @param array<string, mixed> $arguments
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $calendar = $arguments['calendar'];
        $acl = $calendar->getAcl();
        return $acl->getIsAdmin();
    }
}
