<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class CanAddReservationViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event to test', true);
    }

    /**
     * Static method which can be overridden by subclasses. If a subclass
     * requires a different (or faster) decision then this method is the one
     * to override and implement.
     *
     * @param array<string, mixed> $arguments
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $event = $arguments['event'];
        if (!$event) {
            return false;
        }
        $calendar = $event->getCalendar();
        $acl = $calendar->getAcl();

        if (!$acl) {
            return false;
        }

        $beginDateTime = $acl->getBookBeginDateTime();
        if ($beginDateTime !== null && $event->getDateTime() < $beginDateTime) {
            return false;
        }
        $endDateTime = $acl->getBookEndDateTime();
        if ($endDateTime !== null && $event->getDateTime() >= $endDateTime) {
            return false;
        }

        if ($calendar->getMaxReservations() <= (is_countable($event->getReservations()) ? count(
            $event->getReservations()
        ) : 0)) {
            return false;
        }
        $numberReservationPerTimeslot = $acl->getNumberReservationPerTimeslot();
        if ($numberReservationPerTimeslot > 0 && $numberReservationPerTimeslot <= (is_countable(
            $event->getUserReservation()
        ) ? count(
            $event->getUserReservation()
        ) : 0)) {
            return false;
        }
        return true;
    }
}
