<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class CanRemoveReservationViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event to test', true);
    }

    /**
     * Static method which can be overridden by subclasses. If a subclass
     * requires a different (or faster) decision then this method is the one
     * to override and implement.
     *
     * @param array<string, mixed> $arguments
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        $event = $arguments['event'];
        //$context = GeneralUtility::makeInstance(Context::class);
        //$frontendUserId = $context->getPropertyFromAspect('frontend.user','id');
        if (empty($event->getUserReservation())) {
            return false;
        }
        $calendar = $event->getCalendar();
        $acl = $calendar->getAcl();

        if (!$acl) {
            return false;
        }

        $beginDateTime = $acl->getCancelBeginDateTime();

        if ($beginDateTime !== null && $event->getDateTime() < $beginDateTime) {
            return false;
        }
        $endDateTime = $acl->getCancelEndDateTime();
        if ($endDateTime !== null && $event->getDateTime() >= $endDateTime) {
            return false;
        }
        return true;
    }
}
