<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder',
        'label' => 'subject',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'sortby' => 'sorting',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'debug_mail, mail_from, subject, email_begin, email_text, email_end, time_modifier',
        'iconfile' => 'EXT:ig_reservations/Resources/Public/Icons/tx_igreservations_domain_model_reminder.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, time_modifier, debug_mail, mail_from, subject, email_begin, email_text, email_end, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => ['type' => 'language'],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'tx_igreservations_domain_model_reminder',
                'foreign_table_where' => 'AND {#tx_igreservations_domain_model_reminder}.{#pid}=###CURRENT_PID### AND {#tx_igreservations_domain_model_reminder}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'debug_mail' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.debug_mail',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'mail_from' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.mail_from',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'subject' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.subject',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'email_begin' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.email_begin',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext:rte_transform'
        ],
        'email_text' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.email_text',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => false,
            ],
            //'defaultExtras' => 'richtext:rte_transform'
        ],
        'email_end' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.email_end',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext:rte_transform'
        ],
        'time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_reminder.time_modifier',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => '1 Tag', 'value' => '+1 day'],
                    ['label' => '2 Tage', 'value' => '+2 days'],
                    ['label' => '3 Tage', 'value' => '+3 days'],
                    ['label' => '4 Tage', 'value' => '+4 days'],
                    ['label' => '5 Tage', 'value' => '+5 days'],
                    ['label' => '6 Tage', 'value' => '+6 days'],
                    ['label' => '7 Tage', 'value' => '+7 days'],
                ],
                'default' => '+1 day',
                'minitems' => 0,
                'maxitems' => 1,
                'nullable' => true
            ],
        ],

    ],
];
