<?php

namespace Ig\IgReservations\Domain\Model;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * Room
 */
class Room extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * size
     *
     * @var string
     */
    protected $size = '';

    /**
     * tables
     *
     * @var string
     */
    protected $tables = '';

    /**
     * canvas
     *
     * @var string
     */
    protected $canvas = '';

    /**
     * blackboard
     *
     * @var string
     */
    protected $blackboard = '';

    /**
     * beamer
     *
     * @var string
     */
    protected $beamer = '';

    /**
     * laptop
     *
     * @var string
     */
    protected $laptop = '';

    /**
     * soundsystem
     *
     * @var string
     */
    protected $soundsystem = '';

    /**
     * microphone
     *
     * @var string
     */
    protected $microphone = '';

    /**
     * images
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     * @TYPO3\CMS\Extbase\Annotation\ORM\Lazy
     */
    protected $images = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the size
     *
     * @return string
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Sets the size
     *
     * @param string $size
     */
    public function setSize($size)
    {
        $this->size = $size;
    }

    /**
     * Returns the tables
     *
     * @return string
     */
    public function getTables()
    {
        return $this->tables;
    }

    /**
     * Sets the tables
     *
     * @param string $tables
     */
    public function setTables($tables)
    {
        $this->tables = $tables;
    }

    /**
     * Returns the canvas
     *
     * @return string
     */
    public function getCanvas()
    {
        return $this->canvas;
    }

    /**
     * Sets the canvas
     *
     * @param string $canvas
     */
    public function setCanvas($canvas)
    {
        $this->canvas = $canvas;
    }

    /**
     * Returns the blackboard
     *
     * @return string
     */
    public function getBlackboard()
    {
        return $this->blackboard;
    }

    /**
     * Sets the blackboard
     *
     * @param string $blackboard
     */
    public function setBlackboard($blackboard)
    {
        $this->blackboard = $blackboard;
    }

    /**
     * Returns the beamer
     *
     * @return string
     */
    public function getBeamer()
    {
        return $this->beamer;
    }

    /**
     * Sets the beamer
     *
     * @param string $beamer
     */
    public function setBeamer($beamer)
    {
        $this->beamer = $beamer;
    }

    /**
     * Returns the laptop
     *
     * @return string
     */
    public function getLaptop()
    {
        return $this->laptop;
    }

    /**
     * Sets the laptop
     *
     * @param string $laptop
     */
    public function setLaptop($laptop)
    {
        $this->laptop = $laptop;
    }

    /**
     * Returns the soundsystem
     *
     * @return string
     */
    public function getSoundsystem()
    {
        return $this->soundsystem;
    }

    /**
     * Sets the soundsystem
     *
     * @param string $soundsystem
     */
    public function setSoundsystem($soundsystem)
    {
        $this->soundsystem = $soundsystem;
    }

    /**
     * Returns the microphone
     *
     * @return string
     */
    public function getMicrophone()
    {
        return $this->microphone;
    }

    /**
     * Sets the microphone
     *
     * @param string $microphone
     */
    public function setMicrophone($microphone)
    {
        $this->microphone = $microphone;
    }

    /**
     * Adds a FileReference
     */
    public function addImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $image)
    {
        $this->images->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $imageToRemove)
    {
        $this->images->detach($imageToRemove);
    }

    /**
     * Returns the images
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     */
    public function getImages()
    {
        return $this->images;
    }

    /**
     * Sets the images
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $images
     */
    public function setImages(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $images)
    {
        $this->images = $images;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->images = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }
}
