<?php

namespace Ig\IgReservations\Domain\Repository;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * The repository for Timeslots
 */
class TimeslotRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    ];
    
    public function secureFind($calendar, $eventStart, $eventEnd)
    {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                $query->greaterThanOrEqual('startTime', $eventStart->format('H:i.s')),
                $query->lessThan('startTime', $eventEnd->format('H:i.s'))
            )
        );
        return $query->execute();
    }
}
