<?php

namespace Ig\IgReservations\ViewHelpers\Calendar;

use Ig\IgReservations\Domain\Model\Calendar;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class IsAdminViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('calendar', Calendar::class, 'Calendar for ACL', true);
    }

    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $calendar = $arguments['calendar'];
        $acl = $calendar->getAcl();
        return $acl->getIsAdmin();
    }
}
