<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class AddViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event for the reservation to add', true);
    }
    /**
     * Static rendering
     *
     * @return mixed
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $event = $arguments['event'];
        $calendar = $event->getCalendar();

        return '<a href="#" data-controller="Ajax" data-action="reservationCreate" data-calendar="' . $event->getCalendar()->getUid() . '" data-timeslot="' . $event->getTimeslot()->getUid() . '" data-date="' . $event->getDate()->format(
            'Y-m-d'
        ) . '" class="button button-new tx-ig-reservations-ajax-command">' . $renderChildrenClosure() . '</a>';

        //        $this->tag->addAttribute('class', $class);
        /*        $this->tag->addAttribute('href', $uri);
        $this->tag->addAttribute('data-url', $uri);
        $this->tag->addAttribute('data-calendar', $event->getCalendar()->getUid());
        $this->tag->addAttribute('data-timeslot', $event->getTimeslot()->getUid());
        $this->tag->addAttribute('data-date', $event->getDate()->format('Y-m-d'));
        $this->tag->setContent($renderChildrenClosure());

        $this->tag->forceClosingTag(true);
        $this->tag->render();
        */
    }
}
