<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

class CanAddReservationViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event to test', true);
    }

    /**
     * This method decides if the condition is TRUE or FALSE. It can be overriden in extending viewhelpers
     * to adjust functionality.
     *
     * @param array $arguments ViewHelper arguments to evaluate the condition for this ViewHelper, allows for
     *                         flexiblity in overriding this method.
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        $event = $arguments['event'];
        if (!$event) {
            return false;
        }
        $calendar = $event->getCalendar();
        $acl = $calendar->getAcl();

        if (!$acl) {
            return false;
        }

        $beginDateTime = $acl->getBookBeginDateTime();
        if ($beginDateTime !== null && $event->getDateTime() < $beginDateTime) {
            return false;
        }
        $endDateTime = $acl->getBookEndDateTime();
        if ($endDateTime !== null && $event->getDateTime() >= $endDateTime) {
            return false;
        }

        if ($calendar->getMaxReservations() <= (is_countable($event->getReservations()) ? count(
            $event->getReservations()
        ) : 0)) {
            return false;
        }
        $numberReservationPerTimeslot = $acl->getNumberReservationPerTimeslot();
        if ($numberReservationPerTimeslot > 0 && $numberReservationPerTimeslot <= (is_countable(
            $event->getUserReservation()
        ) ? count(
            $event->getUserReservation()
        ) : 0)) {
            return false;
        }
        return true;
    }
}
