<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class CommandViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    protected static $data = [
        'confirm-title',
        'confirm-content',
        'confirm-button-ok-text',
        'confirm-button-ok-class',
        'confirm-button-cancel-text',
        'confirm-button-cancel-class',
    ];

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event Object', true);
        $this->registerArgument('controller', 'string', 'ajax command controller', false, 'Ajax');
        $this->registerArgument('action', 'string', 'ajax command action', true);
        $this->registerArgument('lightbox', 'bool', 'show response of comman in lightbox', false, false);
        $this->registerArgument('class', 'string', 'CSS class', false, '');
        $this->registerArgument('title', 'string', 'title tag', false, '');
        foreach (self::$data as $dataName) {
            $this->registerArgument(
                $dataName,
                'string',
                'Attribute data-' . $dataName . ' - Für Confirm Box vor Ajax Command',
                false,
                ''
            );
        }
    }
    /**
     * Static rendering
     *
     * @return mixed
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $event = $arguments['event'];
        $controller = $arguments['controller'];
        $action = $arguments['action'];
        $calendar = $event->getCalendar();
        $lightbox = $arguments['lightbox'];
        $class = $arguments['class'];
        $title = $arguments['title'];
        
        $src = ' class="tx-ig-reservations-ajax-command ' . ($class ? htmlspecialchars(
            (string) $class
        ) : '') . '"';
        if ($lightbox) {
            $src .= ' data-lightbox="1"';
        }
        if ($title) {
            $src .= ' title="' . htmlspecialchars((string) $title) . '"';
        }
        foreach (self::$data as $dataName) {
            $value = $arguments[$dataName];
            if ($value) {
                $src .= ' data-' . $dataName . '="' . htmlspecialchars((string) $value) . '"';
            }
        }

        return '<a href="#"  data-controller="' . $controller . '" data-action="' . $action . '" data-calendar="' . $event->getCalendar()->getUid() . '" data-event="' . $event->getUid() . '" data-timeslot="' . $event->getTimeslot()->getUid() . '" data-date="' . $event->getDate()->format(
            'Y-m-d'
        ) . '"' . $src . '>' . $renderChildrenClosure() . '</a>';
    }
}
