<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class MenuViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event to test', true);
        $this->registerArgument(
            'class',
            'string',
            'CSS class',
            false,
            ''//'button button-menu'
        );
    }
    /**
     * Static rendering
     *
     * @return mixed
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $event = $arguments['event'];
        $class = $arguments['class'];
        $calendar = $event->getCalendar();

        $src = ' class="' . ($class ? htmlspecialchars((string) $class) : '') . '"';


        return '<a href="#" data-free="' . (is_countable($event->getFreePlaces()) ? count(
            $event->getFreePlaces()
        ) : 0) . '" data-controller="Ajax" data-action="new" data-calendar="' . $event->getCalendar()->getUid() . '" data-timeslot="' . $event->getTimeslot()->getUid() . '" data-date="' . $event->getDate()->format(
            'Y-m-d'
        ) . '" ' . $src . '>' . $renderChildrenClosure() . '</a>';

        //        $this->tag->addAttribute('class', $class);
        /*        $this->tag->addAttribute('href', $uri);
        $this->tag->addAttribute('data-url', $uri);
        $this->tag->addAttribute('data-calendar', $event->getCalendar()->getUid());
        $this->tag->addAttribute('data-timeslot', $event->getTimeslot()->getUid());
        $this->tag->addAttribute('data-date', $event->getDate()->format('Y-m-d'));
        $this->tag->setContent($renderChildrenClosure());

        $this->tag->forceClosingTag(true);
        $this->tag->render();
        */
    }
}
