<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Event;
use Ig\IgReservations\Domain\Model\Reservation;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RemoveViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    protected static $data = [
        'confirm-title',
        'confirm-content',
        'confirm-button-ok-text',
        'confirm-button-ok-class',
        'confirm-button-cancel-text',
        'confirm-button-cancel-class',
    ];


    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event to remove a reservation', true);
        $this->registerArgument('reservation', Reservation::class, 'reservation to delete', false);
        $this->registerArgument(
            'class',
            'string',
            'CSS class',
            false,
            ''//'button button-delete'
        );
        $this->registerArgument('title', 'string', 'title tag', false, '');
        foreach (self::$data as $dataName) {
            $this->registerArgument(
                $dataName,
                'string',
                'Attribute data-' . $dataName . ' - Für Confirm Box vor Ajax Command',
                false,
                ''
            );
        }
    }
    /**
     * Static rendering
     *
     * @return mixed
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $reservation = $arguments['reservation'];
        $event = $arguments['event']; // $reservation->getEvent();
        $calendar = $event->getCalendar();
        $class = $arguments['class'];
        $title = $arguments['title'];

        $src = ' class="tx-ig-reservations-ajax-command ' . ($class ? htmlspecialchars((string) $class) : '') . '"';
        if ($title) {
            $src .= ' title="' . htmlspecialchars((string) $title) . '"';
        }
        foreach (self::$data as $dataName) {
            $value = $arguments[$dataName];
            if ($value) {
                $src .= ' data-' . $dataName . '="' . htmlspecialchars((string) $value) . '"';
            }
        }

        return '<a href="#" data-controller="Ajax" data-action="reservationRemove" data-reservation="' . ($reservation ? $reservation->getUid() : '') . '" data-calendar="' . $event->getCalendar()->getUid() . '" data-timeslot="' . $event->getTimeslot()->getUid() . '" data-date="' . $event->getDate()->format(
            'Y-m-d'
        ) . '"' . $src . '>' . $renderChildrenClosure() . '</a>';

        //        $this->tag->addAttribute('class', $class);
        /*        $this->tag->addAttribute('href', $uri);
        $this->tag->addAttribute('data-url', $uri);
        $this->tag->addAttribute('data-calendar', $event->getCalendar()->getUid());
        $this->tag->addAttribute('data-timeslot', $event->getTimeslot()->getUid());
        $this->tag->addAttribute('data-date', $event->getDate()->format('Y-m-d'));
        $this->tag->setContent($renderChildrenClosure());

        $this->tag->forceClosingTag(true);
        $this->tag->render();
        */
    }
}
