window.initDeleteConfirm = function(event) {
    event.preventDefault();
    var $element = $(event.currentTarget);
    var confirmTitle = $element.data('confirmTitle');
    var confirmContent = $element.data('confirmContent');
    if (confirmContent || confirmTitle) {
	var confirmButtonOkText = $element.data('confirmButtonOkText');
	var confirmButtonCancelText = $element.data('confirmButtonCancelText');
	var confirmButtonOkClass = $element.data('confirmButtonOkClass');
	var confirmButtonCancelClass = $element.data('confirmButtonCancelClass');
	$.confirm({
	    title: confirmTitle ? confirmTitle : '',
	    content: confirmContent,
	    buttons: {
		confirm: {
		    useBootstrap: false,
		    text: confirmButtonOkText ? confirmButtonOkText : 'Ok',
		    btnClass: confirmButtonOkClass ? confirmButtonOkClass : 'btn-ok',
		    action: function() {
			location.href = $element.attr('href');
                    }
		},
		cancel: {
		    text: confirmButtonCancelText ? confirmButtonCancelText : 'Abbrechen',
		    btnClass: confirmButtonCancelClass ? confirmButtonCancelClass : 'btn-cancel',
		}
	    }
	});
    }
};
