<?php

namespace Ig\IgReservations\Controller;

use Ig\IgReservations\Domain\Model\Location;
use Ig\IgReservations\Service\MailService;
use Ig\IgReservations\Service\UserService;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * EventController
 */
class LocationController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * locationRepository
     *
     * @var \Ig\IgReservations\Domain\Repository\LocationRepository
     */
    protected $locationRepository = null;

    /**
     * bookingTypeRepository
     *
     * @var \Ig\IgReservations\Domain\Repository\BookingTypeRepository
     */
    protected $bookingTypeRepository = null;

    /**
     * MailService
     *
     * @var MailService
     */
    protected $mailService = null;

    /**
     * @var \Ig\IgReservations\Domain\Service\UserService
     */
    protected UserService $userService;

    
    public function injectLocationRepository(
        \Ig\IgReservations\Domain\Repository\LocationRepository $locationRepository
    ): void {
        $this->locationRepository = $locationRepository;
    }

    
    public function injectBookingTypeRepository(
        \Ig\IgReservations\Domain\Repository\BookingTypeRepository $bookingTypeRepository
    ): void {
        $this->bookingTypeRepository = $bookingTypeRepository;
    }


    public function injectMailService(MailService $mailService): void
    {
        $this->mailService = $mailService;
    }

    public function injectUserService(UserService $userService): void
    {
        $this->userService = $userService;
    }

    public function initializeAction(): void
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addCssFile('EXT:ig_reservations/Resources/Public/Lib/jquery-confirm/jquery-confirm.min.css');
        $pageRenderer->addCssFile('EXT:ig_reservations/Resources/Public/Css/ig_reservations.scss');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/Lib/jquery-confirm/jquery-confirm.min.js');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/JavaScript/ConfirmDelete.js');
        $pageRenderer->addJsFooterFile('EXT:ig_reservations/Resources/Public/JavaScript/ig_reservations.js');
        $this->mailService->setSettings($this->settings);
        $this->mailService->setRequest($this->request);
    }

    public function listAction(): ResponseInterface
    {
        $bookingTypeUid = $this->settings['bookingType'];
        $bookingType = $this->bookingTypeRepository->findByUid($bookingTypeUid);
        $locations = $this->locationRepository->findByBookingType($bookingTypeUid);


        $this->view->assign('locations', $locations);
        $this->view->assign('bookingType', $bookingType);

        return $this->htmlResponse();
    }

    public function managementListAction(): ResponseInterface
    {
        $locations = $this->locationRepository->findAll();
        $this->view->assign('locations', $locations);
        return $this->htmlResponse();
    }

    
    public function newAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newLocation")
     */
    public function createAction(Location $newLocation): ResponseInterface
    {
        $this->locationRepository->add($newLocation);
        return $this->redirect('list');
    }

    /**
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("location")
     */
    public function editAction(Location $location): ResponseInterface
    {
        $this->view->assign('location', $location);
        return $this->htmlResponse();
    }

    /**
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="location")
     */
    public function updateAction(Location $location): ResponseInterface
    {
        $this->locationRepository->update($location);
        return $this->redirect('list');
    }

    
    public function deleteAction(Location $location): ResponseInterface
    {
        $this->locationRepository->remove($location);
        return $this->redirect('list');
    }

    protected function initializeView($view): void
    {
        $user = $this->userService->getUser();
        $view->assign('user', $user);
    }
}
