<?php

namespace Ig\IgReservations\Domain\Model;

/**
 * BlockingTime
 */
class BlockingTime extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * startDate
     */
    protected ?\DateTime $startDate = null;

    /**
     * startTime
     *
     * @var string
     */
    protected $startTime = 0;

    /**
     * endDate
     *
     * @var \DateTime
     */
    protected $endDate = null;

    /**
     * endTime
     *
     * @var string
     */
    protected $endTime = 0;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * calendar
     *
     * @var \Ig\IgReservations\Domain\Model\Calendar
     */
    protected $calendar = null;

    /**
     * Returns the startDate
     *
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Sets the startDate
     */
    public function setStartDate(\DateTime $startDate)
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the startTime
     *
     * @return string
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    public function getStartTimeFormat()
    {
        return substr($this->startTime, 0, 5);
    }

    public function getStartDateTime()
    {
        if ($this->startDate) {
            return new \DateTime($this->getStartDate()->format('Y-m-d') . 'T' . ($this->startTime ?: '00:00:00'));
        }
        return null;
    }

    /**
     * Sets the startTime
     */
    public function setStartTime(string $startTime)
    {
        $this->startTime = $startTime;
    }

    /**
     * Returns the endDate
     *
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Sets the endDate
     */
    public function setEndDate(\DateTime $endDate)
    {
        $this->endDate = $endDate;
    }

    /**
     * Returns the endTime
     *
     * @return string
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    public function getEndTimeFormat()
    {
        return substr($this->endTime, 0, 5);
    }

    public function getEndDateTime()
    {
        if ($this->endDate) {
            return new \DateTime($this->getEndDate()->format('Y-m-d') . 'T' . ($this->startTime ?: '00:00:00'));
        }
        return null;
    }


    public function getStartEndDateTime()
    {
        $ret = $this->getStartDate()
->format('d.m.Y') . ' ' . $this->getStartTimeFormat() . ' - ';
        $ret .= ($this->getStartDate() != $this->getEndDate() ? $this->getEndDate()->format(
            'd.m.Y'
        ) . ' ' : '') . $this->getEndTimeFormat();
        return $ret;
    }


    /**
     * Sets the endTime
     */
    public function setEndTime(string $endTime)
    {
        $this->endTime = $endTime;
    }


    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the calendar
     *
     * @return \Ig\IgReservations\Domain\Model\Calendar
     */
    public function getCalendar()
    {
        return $this->calendar;
    }

    /**
     * Sets the calendar
     */
    public function setCalendar(\Ig\IgReservations\Domain\Model\Calendar $calendar)
    {
        $this->calendar = $calendar;
    }
}
