<?php

namespace Ig\IgReservations\Domain\Model;

/**
 * CalendarGroup
 */
class CalendarGroup extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     * @var string
     */
    protected $name = '';

    /**
     * calendars
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Calendar>
     */
    protected $calendars = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Adds a Calendar
     */
    public function addCalendar(\Ig\IgReservations\Domain\Model\Calendar $calendar)
    {
        $this->calendars->attach($calendar);
    }

    /**
     * Removes a Calendar
     *
     * @param \Ig\IgReservations\Domain\Model\Calendar $calendarToRemove The Calendar to be removed
     */
    public function removeCalendar(\Ig\IgReservations\Domain\Model\Calendar $calendarToRemove)
    {
        $this->calendars->detach($calendarToRemove);
    }

    /**
     * Returns the calendars
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Calendar> $calendars
     */
    public function getCalendars()
    {
        return $this->calendars;
    }

    /**
     * Sets the calendars
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Calendar> $calendars
     */
    public function setCalendars(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $calendars)
    {
        $this->calendars = $calendars;
    }



    /**
     * Get the value of name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set the value of name
     *
     * @param string $name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->calendars = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }
}
