<?php

namespace Ig\IgReservations\Domain\Model;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <typo3@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * CalendarTimeslots
 */
class CalendarTimeslots extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * timeslots
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Timeslot>
     */
    protected $timeslots = null;

    /**
     * restrictions
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Restriction>
     */
    protected $restrictions = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Adds a Timeslot
     */
    public function addTimeslot(\Ig\IgReservations\Domain\Model\Timeslot $timeslot)
    {
        $this->timeslots->attach($timeslot);
    }

    /**
     * Removes a Timeslot
     *
     * @param \Ig\IgReservations\Domain\Model\Timeslot $timeslotToRemove The Timeslot to be removed
     */
    public function removeTimeslot(\Ig\IgReservations\Domain\Model\Timeslot $timeslotToRemove)
    {
        $this->timeslots->detach($timeslotToRemove);
    }

    /**
     * Returns the timeslots
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Timeslot> $timeslots
     */
    public function getTimeslots()
    {
        return $this->timeslots;
    }

    /**
     * Sets the timeslots
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Timeslot> $timeslots
     */
    public function setTimeslots(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $timeslots)
    {
        $this->timeslots = $timeslots;
    }

    /**
     * Adds a Restriction
     */
    public function addRestriction(\Ig\IgReservations\Domain\Model\Restriction $restriction)
    {
        $this->restrictions->attach($restriction);
    }

    /**
     * Removes a Restriction
     *
     * @param \Ig\IgReservations\Domain\Model\Restriction $restrictionToRemove The Restriction to be removed
     */
    public function removeRestriction(\Ig\IgReservations\Domain\Model\Restriction $restrictionToRemove)
    {
        $this->restrictions->detach($restrictionToRemove);
    }

    /**
     * Returns the restrictions
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Restriction> $restrictions
     */
    public function getRestrictions()
    {
        return $this->restrictions;
    }

    /**
     * Sets the restrictions
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgReservations\Domain\Model\Restriction> $restrictions
     */
    public function setRestrictions(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $restrictions)
    {
        $this->restrictions = $restrictions;
    }

    /**
     * is this calendarTimeslors match for this weekday
     *
     * @param int $weekday Weekday to match
     */
    public function isMatchByWeekday(int $weekday): bool
    {
        foreach ($this->restrictions as $restriction) {
            if ($restriction->getWeekday() == $weekday) {
                return true;
            }
        }
        return false;
    }
    /**
     * is this calendarTimeslors without restrictions
     */
    public function isMatchNoRestrictions(): bool
    {
        return (is_countable($this->restrictions) ? count($this->restrictions) : 0) == 0;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->timeslots = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this->restrictions = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }
}
