<?php

namespace Ig\IgReservations\Domain\Model;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * Category
 */
class Category extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * public
     *
     * @var bool
     */
    protected $public = false;

    /**
     * adminOnly
     *
     * @var bool
     */
    protected $adminOnly = false;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the public
     *
     * @return bool
     */
    public function getPublic()
    {
        return $this->public;
    }

    /**
     * Sets the public
     *
     * @param bool $public
     */
    public function setPublic($public)
    {
        $this->public = $public;
    }

    /**
     * Returns the boolean state of public
     *
     * @return bool
     */
    public function isPublic()
    {
        return $this->public;
    }

    /**
     * Returns the adminOnly
     *
     * @return bool
     */
    public function getAdminOnly()
    {
        return $this->adminOnly;
    }

    /**
     * Sets the adminOnly
     *
     * @param bool $adminOnly
     */
    public function setAdminOnly($adminOnly)
    {
        $this->adminOnly = $adminOnly;
    }

    /**
     * Returns the boolean state of adminOnly
     *
     * @return bool
     */
    public function isAdminOnly()
    {
        return $this->adminOnly;
    }
}
