<?php

namespace Ig\IgReservations\Domain\Repository;

/**
 * The repository for Calendars
 */
class CalendarRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    ];

    public function findInUids(array $uids)
    {
        $query = $this->createQuery();
        $query->matching($query->in('uid', $uids));
        return $query->execute();
    }

    public function getInUids(array $uids): array
    {
        $queryResult = $this->findInUids($uids);
        return $queryResult->toArray();
    }
    
    public function findByNotInUids(array $uids = [])
    {
        $query = $this->createQuery();

        if (!empty($uids)) {
            $query->matching($query->logicalNot($query->in('uid', $uids)));
        }

        return $query->execute();
    }

    public function findAllIgnoreStoragePid()
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectStoragePage(false);
        return $query->execute();
    }
}
