<?php

namespace Ig\IgReservations\ViewHelpers\Reservation;

use Ig\IgReservations\Domain\Model\Category;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class EventCategoryForLanguageViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * @var DataMapper
     */
    protected $dataMapper;

    public function injectDataMapper(DataMapper $dataMapper): void
    {
        $this->dataMapper = $dataMapper;
    }

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('reservation', 'object', 'The reservation object', true);
        $this->registerArgument('as', 'string', 'The variable name to assign the Category object', false, 'category');
    }

    public function render()
    {
        $reservation = $this->arguments['reservation'];
        $event = $reservation->getEvent();
        $language = $reservation->getLanguage();
        $variableName = $this->arguments['as'];

        $category = $event->getCategory();
        $localizedObject = $category;

        if ($category && $language > 0) {
            $uid = $category->getUid();

            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igreservations_domain_model_category'
            );
            $row = $queryBuilder->select('*')
                ->from('tx_igreservations_domain_model_category')
                ->where(
                    $queryBuilder->expr()
->or($queryBuilder->expr() ->eq('uid', $uid), $queryBuilder->expr() ->eq('l10n_parent', $uid)),
                    $queryBuilder->expr()
->eq('sys_language_uid', $language)
                )
                ->executeQuery()
                ->fetchAssociative();

            if ($row) {
                $res = $this->dataMapper->map(Category::class, [$row]);
                $localizedObject = $res[0];
            }
        }

        if ($variableName) {
            $this->templateVariableContainer->add($variableName, $localizedObject);
        }

        $output = $this->renderChildren();

        if ($variableName) {
            $this->templateVariableContainer->remove($variableName);
        }

        return $output;
    }
}
