/* dynamic Context Menu Elements: build submenu items depending on number of free slots */
igCalendar.getItems = function($trigger,igCalendar) {
    var items = {};
    var multiItems = {};
    var free = $trigger.data('free');
    if(free>0) {
	for(i=1;i<=free;i++) {
	    multiItems[i] = {
		"name": i,
		callback: function(key, opt){
 		    var command = igCalendar.getCommandElement('Ajax', 'reservationCreate', $trigger);
		    igCalendar.callCommandWithArgs(command, $('#timeslot-' + command.args.calendar + '-' + command.args.date + '-'+ command.args.timeslot), {multi: key});
		}
	    };
	}
	items['frontenduser'] = {
	    name: "Buchen als Benutzer",
	    callback: function(key, opt){
		var command = igCalendar.getCommandElement('Ajax', 'frontendUserForm', $trigger);
		igCalendar.fancyboxOpenAjaxCommand(command);
		//fancyboxOpenInline(command);
	    }
	};
	items['guest'] =  {
	    name: "Buchen als Gast",
	    callback: function(key, opt){
		var command = igCalendar.getCommandElement('Ajax', 'guestForm', $trigger);
		igCalendar.fancyboxOpenAjaxCommand(command);
		//fancyboxOpenInline(command);
	    }
	};
	items['multi'] = {
	    name: "Mehrere Buchen",
	    "items": multiItems
	};
	items['sep1'] = "---------";
    }
    items['show'] = {
	name: "Details anzeigen",
	callback: function(key, opt)
	{
	    var command = igCalendar.getCommandElement('Ajax', 'eventShow', $trigger);
	    igCalendar.fancyboxOpenAjaxCommand(command);
	}
    }
    return items;
};
