<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <typo3@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * CalendarTimeslots
 */
class CalendarTimeslots extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * timeslots
     *
     * @var ObjectStorage<Timeslot>
     */
    protected $timeslots = null;

    /**
     * restrictions
     *
     * @var ObjectStorage<Restriction>
     */
    protected $restrictions = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Adds a Timeslot
     */
    public function addTimeslot(Timeslot $timeslot): void
    {
        $this->timeslots->attach($timeslot);
    }

    /**
     * Removes a Timeslot
     *
     * @param Timeslot $timeslotToRemove The Timeslot to be removed
     */
    public function removeTimeslot(Timeslot $timeslotToRemove): void
    {
        $this->timeslots->detach($timeslotToRemove);
    }

    /**
     * Returns the timeslots
     *
     * @return ObjectStorage<Timeslot> $timeslots
     */
    public function getTimeslots()
    {
        return $this->timeslots;
    }

    /**
     * Sets the timeslots
     *
     * @param ObjectStorage<Timeslot> $timeslots
     */
    public function setTimeslots(ObjectStorage $timeslots): void
    {
        $this->timeslots = $timeslots;
    }

    /**
     * Adds a Restriction
     */
    public function addRestriction(Restriction $restriction): void
    {
        $this->restrictions->attach($restriction);
    }

    /**
     * Removes a Restriction
     *
     * @param Restriction $restrictionToRemove The Restriction to be removed
     */
    public function removeRestriction(Restriction $restrictionToRemove): void
    {
        $this->restrictions->detach($restrictionToRemove);
    }

    /**
     * Returns the restrictions
     *
     * @return ObjectStorage<Restriction> $restrictions
     */
    public function getRestrictions()
    {
        return $this->restrictions;
    }

    /**
     * Sets the restrictions
     *
     * @param ObjectStorage<Restriction> $restrictions
     */
    public function setRestrictions(ObjectStorage $restrictions): void
    {
        $this->restrictions = $restrictions;
    }

    /**
     * is this calendarTimeslors match for this weekday
     *
     * @param int $weekday Weekday to match
     */
    public function isMatchByWeekday(int $weekday): bool
    {
        foreach ($this->restrictions as $restriction) {
            if ($restriction->getWeekday() == $weekday) {
                return true;
            }
        }
        return false;
    }
    /**
     * is this calendarTimeslors without restrictions
     */
    public function isMatchNoRestrictions(): bool
    {
        return (is_countable($this->restrictions) ? count($this->restrictions) : 0) == 0;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->timeslots = new ObjectStorage();
        $this->restrictions = new ObjectStorage();
    }
}
