<?php

namespace Ig\IgReservations\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***
 *
 * This file is part of the "Reservation Tool" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * Status
 */
class Status extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * color
     *
     * @var string
     */
    protected $color = '';

    /**
     * isDefault
     *
     * @var bool
     */
    protected $isDefault = false;

    /**
     * needsAction
     *
     * @var bool
     */
    protected $needsAction = false;

    /**
     * needsMember
     *
     * @var bool
     */
    protected $needsMember = false;

    /**
     * noReservationAllowed
     *
     * @var bool
     */
    protected $noReservationAllowed = false;

    /**
     * showPublic
     *
     * @var bool
     */
    protected $showPublic = false;

    /**
     * confirmed
     *
     * @var bool
     */
    protected $confirmed = false;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Sets the color
     *
     * @param string $color
     */
    public function setColor($color): void
    {
        $this->color = $color;
    }

    /**
     * Returns the isDefault
     *
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }

    /**
     * Sets the isDefault
     *
     * @param bool $isDefault
     */
    public function setIsDefault($isDefault): void
    {
        $this->isDefault = $isDefault;
    }

    /**
     * Returns the boolean state of isDefault
     *
     * @return bool
     */
    public function isIsDefault()
    {
        return $this->isDefault;
    }

    /**
     * Get the value of needsAction
     *
     * @return bool
     */
    public function getNeedsAction()
    {
        return $this->needsAction;
    }

    /**
     * Set the value of needsAction
     *
     * @param bool $needsAction
     *
     * @return self
     */
    public function setNeedsAction($needsAction)
    {
        $this->needsAction = $needsAction;

        return $this;
    }

    /**
     * Get the value of needsMember
     *
     * @return bool
     */
    public function getNeedsMember()
    {
        return $this->needsMember;
    }

    /**
     * Set the value of needsMember
     *
     * @param bool $needsMember
     *
     * @return self
     */
    public function setNeedsMember($needsMember)
    {
        $this->needsMember = $needsMember;

        return $this;
    }

    /**
     * Get the value of noReservationAllowed
     *
     * @return bool
     */
    public function getNoReservationAllowed()
    {
        return $this->noReservationAllowed;
    }

    /**
     * Set the value of noReservationAllowed
     *
     * @param bool $noReservationAllowed
     *
     * @return self
     */
    public function setNoReservationAllowed($noReservationAllowed)
    {
        $this->noReservationAllowed = $noReservationAllowed;

        return $this;
    }



    /**
     * Get the value of showPublic
     *
     * @return bool
     */
    public function getShowPublic()
    {
        return $this->showPublic;
    }

    /**
     * Set the value of showPublic
     *
     * @param bool $showPublic
     */
    public function setShowPublic($showPublic): void
    {
        $this->showPublic = $showPublic;
    }

    /**
     * Get the value of confirmed
     *
     * @return bool
     */
    public function getConfirmed()
    {
        return $this->confirmed;
    }

    /**
     * Set the value of confirmed
     *
     * @param bool $confirmed
     */
    public function setConfirmed($confirmed): void
    {
        $this->confirmed = $confirmed;
    }
}
