<?php

namespace Ig\IgReservations\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Calendars
 */
class CalendarRepository extends Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'sorting' => QueryInterface::ORDER_ASCENDING,
    ];

    public function findInUids(array $uids)
    {
        $query = $this->createQuery();
        $query->matching($query->in('uid', $uids));
        return $query->execute();
    }

    public function getInUids(array $uids): array
    {
        $queryResult = $this->findInUids($uids);
        return $queryResult->toArray();
    }
    
    public function findByNotInUids(array $uids = [])
    {
        $query = $this->createQuery();

        if (!empty($uids)) {
            $query->matching($query->logicalNot($query->in('uid', $uids)));
        }

        return $query->execute();
    }

    public function findAllIgnoreStoragePid()
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectStoragePage(false);
        return $query->execute();
    }
}
