<?php

namespace Ig\IgReservations\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserRepository;

/**
 * The repository for FeUsers
 */
class FeUserRepository extends FrontendUserRepository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'last_name' => QueryInterface::ORDER_ASCENDING,
        'first_name' => QueryInterface::ORDER_ASCENDING,
        'username' => QueryInterface::ORDER_ASCENDING,
    ];
    public function initializeObject(): void
    {
        $querySettings = $this->createQuery()
->getQuerySettings();
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findTeammembers($usergroupUid = 0)
    {
        $query = $this->createQuery();

        if ($usergroupUid) {
            $query->matching(
                $query->logicalOr(
                    $query->equals('usergroup.uid', $usergroupUid),
                    $query->equals('usergroup.subgroup.uid', $usergroupUid)
                )
            );
        } else {
            $query->matching(
                $query->logicalOr(
                    $query->equals('usergroup.title', 'reservations-team'),
                    $query->equals('usergroup.subgroup.title', 'reservations-team')
                )
            );
        }

        return $query->execute();
    }
    public function findAjaxRaw(array $search = [])
    {
        $query = $this->createQuery();
        return $query->execute(true);
    }
}
