<?php

namespace Ig\IgReservations\ViewHelpers\Event;

use Ig\IgReservations\Domain\Model\Timeslot;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TimeslotForLanguageViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * @var DataMapper
     */
    protected $dataMapper;

    public function injectDataMapper(DataMapper $dataMapper): void
    {
        $this->dataMapper = $dataMapper;
    }

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('event', 'object', 'The event object', true);
        $this->registerArgument('language', 'int', 'The language UID', false, 0);
        $this->registerArgument('as', 'string', 'The variable name to assign the Timeslot object', false, 'timeslot');
    }

    public function render()
    {
        $event = $this->arguments['event'];
        $language = $this->arguments['language'];
        $variableName = $this->arguments['as'];

        $timeslot = $event->getTimeslot();
        $localizedObject = $timeslot;

        if ($timeslot && $language > 0) {
            $uid = $timeslot->getUid();

            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_extension_domain_model_timeslot'
            );
            $row = $queryBuilder->select('*')
                ->from('tx_extension_domain_model_timeslot')
                ->where(
                    $queryBuilder->expr()
->or($queryBuilder->expr() ->eq('uid', $uid), $queryBuilder->expr() ->eq('l10n_parent', $uid)),
                    $queryBuilder->expr()
->eq('sys_language_uid', $language)
                )
                ->executeQuery()
                ->fetchAssociative();

            if ($row) {
                $res = $this->dataMapper->map(Timeslot::class, [$row]);
                $localizedObject = $res[0];
            }
        }

        if ($variableName) {
            $this->templateVariableContainer->add($variableName, $localizedObject);
        }

        $output = $this->renderChildren();

        if ($variableName) {
            $this->templateVariableContainer->remove($variableName);
        }

        return $output;
    }
}
