<?php

namespace Ig\IgReservations\ViewHelpers\Reservation;

use Closure;
use Ig\IgReservations\Domain\Model\Event;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class AddViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('event', Event::class, 'event for the reservation to add', true);
        $this->registerArgument(
            'class',
            'string',
            'CSS class',
            false,
            ''//'button button-new'
        );
        $this->registerArgument('title', 'string', 'title tag', false, '');
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $lightbox = null;
        $event = $arguments['event'];
        $calendar = $event->getCalendar();
        $class = $arguments['class'];
        $title = $arguments['title'];
        
        $src = ' class="tx-ig-reservations-ajax-command ' . ($class ? htmlspecialchars(
            (string) $class
        ) : '') . '"';
        if ($lightbox) {
            $src .= ' data-lightbox="1"';
        }
        if ($title) {
            $src .= ' title="' . htmlspecialchars((string) $title) . '"';
        }
        
        return '<a href="#" data-controller="Ajax" data-action="reservationCreate" data-calendar="' . $event->getCalendar()->getUid() . '" data-timeslot="' . $event->getTimeslot()->getUid() . '" data-date="' . $event->getDate()->format(
            'Y-m-d'
        ) . '" class="button button-new tx-ig-reservations-ajax-command"' . $src . '>' . $this->renderChildren() . '</a>';
    }
}
