<?php

namespace Ig\IgReservations\ViewHelpers\Reservation;

use Ig\IgReservations\Domain\Model\Location;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class EventLocationForLanguageViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * @var DataMapper
     */
    protected $dataMapper;

    public function injectDataMapper(DataMapper $dataMapper): void
    {
        $this->dataMapper = $dataMapper;
    }

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('reservation', 'object', 'The reservation object', true);
        $this->registerArgument('as', 'string', 'The variable name to assign the Location object', false, 'location');
    }

    public function render()
    {
        $reservation = $this->arguments['reservation'];
        $event = $reservation->getEvent();
        $language = $reservation->getLanguage();
        $variableName = $this->arguments['as'];

        $location = $event->getLocation();
        $localizedObject = $location;

        if ($location && $language > 0) {
            $uid = $location->getUid();

            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igreservations_domain_model_location'
            );
            $row = $queryBuilder->select('*')
                ->from('tx_igreservations_domain_model_location')
                ->where(
                    $queryBuilder->expr()
->or($queryBuilder->expr() ->eq('uid', $uid), $queryBuilder->expr() ->eq('l10n_parent', $uid)),
                    $queryBuilder->expr()
->eq('sys_language_uid', $language)
                )
                ->executeQuery()
                ->fetchAssociative();

            if ($row) {
                $res = $this->dataMapper->map(Location::class, [$row]);
                $localizedObject = $res[0];
            }
        }

        if ($variableName) {
            $this->templateVariableContainer->add($variableName, $localizedObject);
        }

        $output = $this->renderChildren();

        if ($variableName) {
            $this->templateVariableContainer->remove($variableName);
        }

        return $output;
    }
}
