<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address',
        'label' => 'last_name',
        'label_alt' => 'first_name, salutation',
        'label_alt_force' => true,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        /*'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',*/
        //'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'first_name,last_name,company,address,zip,city,email,phone',
        'iconfile' => 'EXT:ig_reservations/Resources/Public/Icons/tx_igreservations_domain_model_address.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'hidden, salutation, first_name, last_name, company, address, zip, city, email, phone, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'salutation' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.salutation',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.salutation.1', 'value' => 1],
                    ['label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.salutation.2', 'value' => 2],
                ],
                'size' => 1,
                'maxitems' => 1,
                'eval' => ''
            ],
        ],
        'first_name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.first_name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'last_name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.last_name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'company' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.company',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'address' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.address',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'zip' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.zip',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'city' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.city',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'email' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.email',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'phone' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_address.phone',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],

    ],
];
