<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'versioningWS' => true,
        /*'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',*/
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,description,show_begin_date_time_modifier,show_end_date_time_modifier,book_begin_date_time_modifier,book_end_date_time_modifier,cancel_begin_date_time_modifier,cancel_end_date_time_modifier,number_reservation_per_timeslot,permissions,fullcalendar',
        'iconfile' => 'EXT:ig_reservations/Resources/Public/Icons/tx_igreservations_domain_model_calendaracl.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'hidden, name, description, frontend_group, show_begin_date_time_modifier, show_end_date_time_modifier, book_begin_date_time_modifier, book_end_date_time_modifier, cancel_begin_date_time_modifier, cancel_end_date_time_modifier, number_reservation_per_timeslot, number_timeslots_per_day, minimum_block_duration, maximum_block_duration, is_admin, permissions, --div--;FullCalendar, fullcalendar, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'name' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'frontend_group' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.frontend_group',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
                'foreign_table' => 'fe_groups',
                'eval' => 'int'
            ]
        ],
        'show_begin_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.show_begin_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'show_end_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.show_end_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'book_begin_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.book_begin_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'book_end_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.book_end_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'cancel_begin_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.cancel_begin_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'cancel_end_date_time_modifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.cancel_end_date_time_modifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'number_reservation_per_timeslot' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.number_reservation_per_timeslot',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'nullable' => true
            ],
        ],
        'number_timeslots_per_day' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.number_timeslots_per_day',
            'config' => [
                'type' => 'number',
                'size' => 4,
                'nullable' => true
            ]
        ],
        'minimum_block_duration' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.minimum_block_duration',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'maximum_block_duration' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.maximum_block_duration',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'nullable' => true,
                'format' => 'decimal',
            ],
        ],
        'is_admin' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.is_admin',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'default' => 0,
            ]
        ],
        'permissions' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.permissions',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectCheckBox',
                'items' => [
                    ['label' => 'Event Details ansehen (Eigentümer)', 'value' => 'eventViewOwner'],
                    ['label' => 'Event Details ansehen (Gruppe)', 'value' => 'eventViewGroup'],
                    ['label' => 'Event Details ansehen (Sonstige)', 'value' => 'eventViewOthers'],
                    ['label' => 'Reservation hinzufügen', 'value' => 'event-reservation-add'],
                    ['label' => 'Meldungen ansehen', 'value' => 'view-message'],
                    ['label' => 'Benutzerinfos ansehen', 'value' => 'view-user'],
                    ['label' => 'Erweiterte Suche', 'value' => 'search-advanced'],
                    ['label' => 'Bufferzeiten werden ausgegeben', 'value' => 'show-buffer-time'],
                    ['label' => 'Events werden zusammengeführt', 'value' => 'merge-events'],
                    ['label' => 'Benutzer (deprecated)', 'value' => 'user'],
                    ['label' => 'Nur Lesezugriff (deprecated)', 'value' => 'read'],
                    ['label' => 'Teammitglied (deprecated)', 'value' => 'team'],
                    ['label' => 'Teammitglieder sehen nur ihre eigenen Buchungen (deprecated)', 'value' => 'teammemberShowMyEvents'],
                ],
            ]
        ],
        'fullcalendar' => [
            'exclude' => true,
            'label' => 'LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_igreservations_domain_model_calendaracl.fullcalendar',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectCheckBox',
                'items' => [
                    ['label' => 'Selektierbar (selectable)', 'value' => 'selectable'],
                    ['label' => 'Editierbar (editable)', 'value' => 'editable'],
                    ['label' => 'Kann überlappen (selectOverlap)', 'value' => 'selectOverlap'],
                    ['label' => 'Event Verschiebbar (eventDrop)', 'value' => 'eventDrop'],
                    ['label' => 'Event Vergrösserbar (eventResize)', 'value' => 'eventResize'],
                ],
            ]
        ],

    ],
];
