<?php
use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Ig\IgReservations\Controller\CalendarController;
use Ig\IgReservations\Controller\EventController;
use Ig\IgReservations\Controller\ReservationController;
use Ig\IgReservations\Controller\AjaxController;
use Ig\IgReservations\Controller\FeUserController;
use Ig\IgReservations\Controller\LocationController;
use Ig\IgReservations\Controller\StatisticController;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;

defined('TYPO3') || die('Access denied.');


ExtensionUtility::configurePlugin(
    'IgReservations',
    'CalendarList',
    [
        CalendarController::class => 'list',
    ],
    // non-cacheable actions
    [
        CalendarController::class => 'list',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'PublicCalendar',
    [
        CalendarController::class => 'show, list',
        EventController::class => 'new, create, edit, update, delete, deleteConfirm, confirm, cut, insert, uncut',
        ReservationController::class => 'new, create, delete, deleteConfirm, cancelRequest, cancelRequestSent',
    ],
    // non-cacheable actions
    [
        CalendarController::class => 'show',
        EventController::class => 'new, create, edit, update, delete, deleteConfirm, confirm, cut, insert, uncut',
        ReservationController::class => 'new, create, delete, deleteConfirm, cancelRequest, cancelRequestSent',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'Ajax',
    [
        AjaxController::class => 'frontendUserForm, guestForm, eventShow, reservationCreateForm, reservationEditForm, reservationRemove, reservationCreate, approveEvent, assignTeammember, teammemberAssignmentForm,reservationCreateFormStartEnd, getEvents, updateEvent, ajaxUpload',
    ],
    // non-cacheable actions
    [
        AjaxController::class => 'frontendUser, guestForm, eventShow, reservationCreateForm, reservationEditForm, reservationRemove, reservationCreate, approveEvent, assignTeammember, teammemberAssignmentForm, getEvents, updateEvent, ajaxUpload',
    ],
);
/*
\TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
    'IgReservations',
    'AjaxEvents',
    [
        \Ig\IgReservations\Controller\AjaxController::class => 'getEvents',
    ],
    // non-cacheable actions
    [
        \Ig\IgReservations\Controller\AjaxController::class => 'getEvents',
    ],
);
*/

ExtensionUtility::configurePlugin(
    'IgReservations',
    'EventTodo',
    [
        EventController::class => 'approvalList, approve, unapprove, show, assignUser, updateTeammember, new, create, edit, update, delete, deleteConfirm, confirm, ajaxUpload',
        ReservationController::class => 'addToEvent, new, create, delete, deleteConfirm, edit, update, showCancelRequest, approveCancelRequest, unapproveCancelRequest, ajaxUpload',
    ],
    // non-cacheable actions
    [
        EventController::class => 'approvalList, approve, unapprove, show, assignUser, updateTeammember, new, create, edit, update, delete, deleteConfirm, confirm, ajaxUpload',
        ReservationController::class => 'addToEvent, new, create, delete, deleteConfirm, edit, update, showCancelRequest, approveCancelRequest, unapproveCancelRequest, ajaxUpload',
    ]
);


ExtensionUtility::configurePlugin(
    'IgReservations',
    'Overview',
    [
        CalendarController::class => 'overview, pdfExport',
    ],
    // non-cacheable actions
    [
        CalendarController::class => 'overview, pdfExport',
    ]
);


ExtensionUtility::configurePlugin(
    'IgReservations',
    'EventList',
    [
        EventController::class => 'list',
        ReservationController::class => 'newBooking,createBooking,thankYouBooking,failedBooking',
    ],
    // non-cacheable actions
    [
        EventController::class => 'list',
        ReservationController::class => 'newBooking,createBooking,thankYouBooking,failedBooking',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'FeUserManagement',
    [
        FeUserController::class => 'managementList,new,create,edit,update,delete',
    ],
    // non-cacheable actions
    [
        FeUserController::class => 'managementList,new,create,edit,update,delete',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'LocationManagement',
    [
        LocationController::class => 'managementList,new,create,edit,update,delete',
    ],
    // non-cacheable actions
    [
        LocationController::class => 'managementList,new,create,edit,update,delete',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'LocationList',
    [
        LocationController::class => 'list',
    ],
    // non-cacheable actions
    [
        LocationController::class => 'list',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'Alarm',
    [
        EventController::class => 'alarmAdmin',
    ],
    // non-cacheable actions
    [
        EventController::class => 'alarmAdmin',
    ]
);


ExtensionUtility::configurePlugin(
    'IgReservations',
    'MyReservations',
    [
        ReservationController::class => 'list, cancelRequest, cancelRequestSent',
    ],
    // non-cacheable actions
    [
        ReservationController::class => 'list, cancelRequest, cancelRequestSent',
    ]
);

ExtensionUtility::configurePlugin(
    'IgReservations',
    'Statistics',
    [
        StatisticController::class => 'show, export',
    ],
    // non-cacheable actions
    [
        StatisticController::class => 'show, export',
    ]
);

// wizards
ExtensionManagementUtility::addPageTSConfig(
    'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    publiccalendar {
                        iconIdentifier = ig_reservations-plugin-public
                        title = LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_ig_reservations_publiccalendar.name
                        description = LLL:EXT:ig_reservations/Resources/Private/Language/locallang_db.xlf:tx_ig_reservations_publiccalendar.description
                        tt_content_defValues {
                            CType = list
                            list_type = igreservations_publiccalendar
                        }
                    }
                }
                show = *
            }
       }'
);
$iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);

$iconRegistry->registerIcon(
    'ig_reservations-plugin-public',
    SvgIconProvider::class,
    ['source' => 'EXT:ig_reservations/Resources/Public/Icons/user_plugin_public.svg']
);

$iconRegistry->registerIcon(
    'ig_reservations-plugin-protected',
    SvgIconProvider::class,
    ['source' => 'EXT:ig_reservations/Resources/Public/Icons/user_plugin_protected.svg']
);

$iconRegistry->registerIcon(
    'ig_reservations-plugin-alarm',
    SvgIconProvider::class,
    ['source' => 'EXT:ig_reservations/Resources/Public/Icons/user_plugin_alarm.svg']
);


$GLOBALS['TYPO3_CONF_VARS']['MAIL']['layoutRootPaths'][1591182943] = 'EXT:ig_reservations/Resources/Private/Email/Layouts/';
$GLOBALS['TYPO3_CONF_VARS']['MAIL']['partialRootPaths'][1591182943] = 'EXT:ig_reservations/Resources/Private/Email/Partials/';
$GLOBALS['TYPO3_CONF_VARS']['MAIL']['templateRootPaths'][1591182943] = 'EXT:ig_reservations/Resources/Private/Email/Templates/';
