#
# Table structure for table 'tx_igreservations_domain_model_event'
#
CREATE TABLE tx_igreservations_domain_model_event (

	create_date date DEFAULT NULL,
	start_date date DEFAULT NULL,
	start_time TIME DEFAULT '00:00:00',
	end_date date DEFAULT NULL,
	end_time TIME DEFAULT '00:00:00',
	name varchar(255) DEFAULT '' NOT NULL,
	description text,
	external_id varchar(255) DEFAULT '' NOT NULL,
	import_id int(11) unsigned DEFAULT '0',
	notes text,
	purpose varchar(255) DEFAULT '' NOT NULL,
	num_participants int(11) DEFAULT '0' NOT NULL,
	category int(11) unsigned DEFAULT '0',
	address int(11) unsigned DEFAULT '0' NOT NULL,
	booking_type int(11) unsigned DEFAULT '0' NOT NULL,
	status int(11) unsigned DEFAULT '0' NOT NULL,
	timeslot int(11) unsigned DEFAULT '0',
	calendar int(11) unsigned DEFAULT '0',
	location_description varchar(255) DEFAULT '' NOT NULL,
	owner int(11) unsigned DEFAULT '0' NOT NULL,
	additional_member int(11) unsigned DEFAULT '0' NOT NULL,
	teammembers int(11) unsigned DEFAULT '0' NOT NULL,
	language int(11) DEFAULT '0' NOT NULL,
	confirmation_sent smallint(5) unsigned DEFAULT '0' NOT NULL,
	is_public smallint(5) unsigned DEFAULT '0' NOT NULL,
	event_group int(11) unsigned DEFAULT '0' NOT NULL,
	calendar_group int(11) unsigned DEFAULT '0' NOT NULL,
	main_event smallint(5) unsigned DEFAULT '0' NOT NULL,
	location int(11) unsigned DEFAULT '0' NOT NULL,
	reservation_types int(11) DEFAULT '0' NOT NULL,
	files int(11) DEFAULT '0' NOT NULL,
	INDEX index_events (start_date, timeslot, calendar),

);

#
# Table structure for table 'tx_igreservations_domain_model_category'
#
CREATE TABLE tx_igreservations_domain_model_category (

	name varchar(255) DEFAULT '' NOT NULL,
	public smallint(5) unsigned DEFAULT '0' NOT NULL,
	admin_only smallint(5) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_calendar'
#
CREATE TABLE tx_igreservations_domain_model_calendar (

	name varchar(255) DEFAULT '' NOT NULL,
	label varchar(255) DEFAULT '' NOT NULL,
	max_reservations int(11) DEFAULT '0' NOT NULL,
	timeslot_start_time int(11),
	timeslot_end_time int(11),
	timeslot_block_duration int(11),
	timeslot_buffer varchar(255) DEFAULT '' NOT NULL,
	page_uid int(11),
	conf text,
	calendar_type int(11) unsigned DEFAULT '0',
	calendar_timeslots int(11) unsigned DEFAULT '0' NOT NULL,
	calendar_acl int(11) unsigned DEFAULT '0' NOT NULL,
	mails_to_send text,
	room int(11) unsigned DEFAULT '0',
	blocking_times int(11) unsigned DEFAULT '0' NOT NULL,
	hide_in_list smallint(5) unsigned DEFAULT '0' NOT NULL,
	frontend_user int(11) DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_timeslot'
#
CREATE TABLE tx_igreservations_domain_model_timeslot (

	start_time TIME DEFAULT '00:00:00',
	end_time TIME DEFAULT '00:00:00',
	name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_status'
#
CREATE TABLE tx_igreservations_domain_model_status (

	name varchar(255) DEFAULT '' NOT NULL,
	color varchar(255) DEFAULT '' NOT NULL,
	is_default smallint(5) unsigned DEFAULT '0' NOT NULL,
	show_public smallint(5) unsigned DEFAULT '0' NOT NULL,
	needs_action smallint(5) unsigned DEFAULT '0' NOT NULL,
	needs_member smallint(5) unsigned DEFAULT '0' NOT NULL,
	no_reservation_allowed smallint(5) unsigned DEFAULT '0' NOT NULL,
	confirmed smallint(5) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_bookingtype'
#
CREATE TABLE tx_igreservations_domain_model_bookingtype (

	name varchar(255) DEFAULT '' NOT NULL,
	purposes varchar(255) DEFAULT '' NOT NULL,
	page_uid int(11),
	is_default smallint(5) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_address'
#
CREATE TABLE tx_igreservations_domain_model_address (

	salutation int(11) DEFAULT '0' NOT NULL,
	first_name varchar(255) DEFAULT '' NOT NULL,
	last_name varchar(255) DEFAULT '' NOT NULL,
	company varchar(255) DEFAULT '' NOT NULL,
	address varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	phone varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'fe_users'
#
CREATE TABLE fe_users (

	purposes varchar(255) DEFAULT '' NOT NULL,
	tx_extbase_type VARCHAR(255) CHARACTER SET utf8 DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_calendartype'
#
CREATE TABLE tx_igreservations_domain_model_calendartype (

	name varchar(255) DEFAULT '' NOT NULL,
	mode int(11) DEFAULT '0' NOT NULL,
	partial varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_calendar'
#
CREATE TABLE tx_igreservations_domain_model_reservation (

	frontend_user int(11) DEFAULT '0' NOT NULL,
	purpose int(11) DEFAULT '0' NOT NULL,
	name varchar(255) DEFAULT '' NOT NULL,
	event int(11) unsigned DEFAULT '0' NOT NULL,
	salutation int(11) DEFAULT '0' NOT NULL,
	first_name varchar(255) DEFAULT '' NOT NULL,
	last_name varchar(255) DEFAULT '' NOT NULL,
	company varchar(255) DEFAULT '' NOT NULL,
	address varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,
	email varchar(255) DEFAULT '' NOT NULL,
	phone varchar(255) DEFAULT '' NOT NULL,
	language int(11) DEFAULT '0' NOT NULL,
	company_address varchar(255) DEFAULT '' NOT NULL,
	company_zip varchar(255) DEFAULT '' NOT NULL,
	company_city varchar(255) DEFAULT '' NOT NULL,
	company_phone varchar(255) DEFAULT '' NOT NULL,
	has_bill_address smallint(5) unsigned DEFAULT '0' NOT NULL,
	bill_name varchar(255) DEFAULT '' NOT NULL,
	bill_address varchar(255) DEFAULT '' NOT NULL,
	bill_zip varchar(255) DEFAULT '' NOT NULL,
	bill_city varchar(255) DEFAULT '' NOT NULL,
	notes text,
	confirmed smallint(5) unsigned DEFAULT '0' NOT NULL,
	reminder_sent smallint(5) unsigned DEFAULT '0' NOT NULL,
	reservation_type int(11) DEFAULT '0' NOT NULL,
        INDEX index_reservation_event (event),

);

#
# Table structure for table 'tx_igreservations_domain_model_reservation'
#
CREATE TABLE tx_igreservations_domain_model_reservationtype (

	name varchar(255) DEFAULT '' NOT NULL,
	is_default smallint(5) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_calendartimeslots'
#
CREATE TABLE tx_igreservations_domain_model_calendartimeslots (

	name varchar(255) DEFAULT '' NOT NULL,
	timeslots int(11) unsigned DEFAULT '0' NOT NULL,
	restrictions int(11) unsigned DEFAULT '0' NOT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_restriction'
#
CREATE TABLE tx_igreservations_domain_model_restriction (

	name varchar(255) DEFAULT '' NOT NULL,
	weekday int(11) DEFAULT '0' NOT NULL,
	holiday smallint(5) unsigned DEFAULT '0' NOT NULL,
	from_date date DEFAULT NULL,
	to_date date DEFAULT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_blockingtime'
#
CREATE TABLE tx_igreservations_domain_model_blockingtime (

	name varchar(255) DEFAULT '' NOT NULL,
	start_date date DEFAULT NULL,
	start_time TIME DEFAULT NULL,
	end_date date DEFAULT NULL,
	end_time TIME DEFAULT NULL,
	calendar int(11) unsigned DEFAULT '0' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_calendaracl'
#
CREATE TABLE tx_igreservations_domain_model_calendaracl (

	name varchar(255) DEFAULT '' NOT NULL,
	description varchar(255) DEFAULT '' NOT NULL,
	frontend_group int(11) DEFAULT '0' NOT NULL,
	show_begin_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	show_end_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	book_begin_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	book_end_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	cancel_begin_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	cancel_end_date_time_modifier varchar(255) DEFAULT '' NOT NULL,
	number_reservation_per_timeslot int(11),
	number_timeslots_per_day int(11),
	minimum_block_duration double(11,2) DEFAULT NULL,
	maximum_block_duration double(11,2) DEFAULT NULL,
	is_admin smallint(5) unsigned DEFAULT '0' NOT NULL,
	permissions text,
	fullcalendar text,

);

#
# Table structure for table 'tx_igreservations_domain_model_room'
#
CREATE TABLE tx_igreservations_domain_model_room (

	name varchar(255) DEFAULT '' NOT NULL,
	size text,
	tables text,
	canvas text,
	blackboard text,
	beamer text,
	laptop text,
	soundsystem text,
	microphone text,
	images int(11) unsigned DEFAULT '0' NOT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_location'
#
CREATE TABLE tx_igreservations_domain_model_location (

	name varchar(255) DEFAULT '' NOT NULL,
	address varchar(255) DEFAULT '' NOT NULL,
	zip varchar(255) DEFAULT '' NOT NULL,
	city varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_import'
#
CREATE TABLE tx_igreservations_domain_model_import (

	path varchar(255) DEFAULT '' NOT NULL,
	calendar int(11) unsigned DEFAULT '0' NOT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_eventgroup'
#
CREATE TABLE tx_igreservations_domain_model_eventgroup (

	repetition varchar(255) DEFAULT '' NOT NULL,
	repeat_till date DEFAULT NULL,
	events int(11) unsigned DEFAULT '0' NOT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_calendargroup'
#
CREATE TABLE tx_igreservations_domain_model_calendargroup (

	name varchar(255) DEFAULT '' NOT NULL,
	calendars int(11) unsigned DEFAULT '0' NOT NULL,
	events int(11) unsigned DEFAULT '0' NOT NULL

);

#
# Table structure for table 'tx_igreservations_domain_model_purpose'
#
CREATE TABLE tx_igreservations_domain_model_purpose (

	name varchar(255) DEFAULT '' NOT NULL,

);

#
# Table structure for table 'tx_igreservations_domain_model_reminder'
#
CREATE TABLE tx_igreservations_domain_model_reminder (

	mail_from varchar(255) DEFAULT '' NOT NULL,
	debug_mail varchar(255) DEFAULT '' NOT NULL,
	subject varchar(255) DEFAULT '' NOT NULL,
	email_begin text,
	email_text text,
	email_end text,
	time_modifier varchar(255) DEFAULT '' NOT NULL

);


#
# Table structure for table 'tx_igreservations_calendar_calendartimeslots_mm'
#
CREATE TABLE tx_igreservations_calendar_calendartimeslots_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_calendar_calendaracl_mm'
#
CREATE TABLE tx_igreservations_calendar_calendaracl_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_calendartimeslots_timeslot_mm'
#
CREATE TABLE tx_igreservations_calendartimeslots_timeslot_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_calendartimeslots_restriction_mm'
#
CREATE TABLE tx_igreservations_calendartimeslots_restriction_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_calendargroup_calendar_mm'
#
CREATE TABLE tx_igreservations_calendargroup_calendar_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_event_teammember_mm'
#
CREATE TABLE tx_igreservations_event_teammember_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);

#
# Table structure for table 'tx_igreservations_event_reservationtype_mm'
#
CREATE TABLE tx_igreservations_event_reservationtype_mm (
	uid_local int(11) unsigned DEFAULT '0' NOT NULL,
	uid_foreign int(11) unsigned DEFAULT '0' NOT NULL,
	sorting int(11) unsigned DEFAULT '0' NOT NULL,
	sorting_foreign int(11) unsigned DEFAULT '0' NOT NULL,

	PRIMARY KEY (uid_local,uid_foreign),
	KEY uid_local (uid_local),
	KEY uid_foreign (uid_foreign)
);
