/*
 *************************************
 * toggle-handler.js
 * global handler for elements with the class ig-togglehandler
 *************************************
 */
class ToggleHandler {
    constructor(config) {
        this.defaultConfig = {};
        this.defaultConfig.elements = document.getElementsByClassName("ig-togglehandler");
        // data-toggleclass on element
        this.defaultConfig.toggleclass = "toggleclass";
        // data-togglefalseclass on element
        this.defaultConfig.togglefalseclass = "togglefalseclass";
        // data-addclasses on element
        this.defaultConfig.addclasses = "addclasses";
        // data-deleteclasses on element
        this.defaultConfig.deleteclasses = "deleteclasses";
        // data-addattribute on element
        this.defaultConfig.addattribute = "addattribute";
        // data-deleteattribute on element
        this.defaultConfig.deleteattribute = "deleteattribute";
        // data-toggleattribute on element
        this.defaultConfig.toggleattribute = "toggleattribute";
        // data-togglefalseattribute on element
        this.defaultConfig.togglefalseattribute = "togglefalseattribute";
        // data-evaljs on element
        this.defaultConfig.evaljs = "evaljs";
        // base if no selector is set
        this.defaultConfig.parseContainer = document.querySelector("html");
        // splits string at , so you can make more than one change
        this.defaultConfig.elementSplit = ",";
        // splits every elementSplit part at | so you get selector|what do do
        this.defaultConfig.stringSplit = "|";
        // splits attributes on = so you can add style=width:10px
        this.defaultConfig.attrSplit = "=";
        this.config = { ...this.defaultConfig, ...config };
        this.currentClicked;
        this.setToggleHandler();
    }
    setToggleHandler() {
        let newToggleClass,
            newToggleClassElements,
            newToggleFalseClass,
            newToggleFalseClassElements,
            newAddClasses,
            newAddClassesElements,
            newDeleteClasses,
            newDeleteClassesElements,
            newAddAttribute,
            newAddAttributeElements,
            newDeleteAttribute,
            newDeleteAttributeElements,
            newToggleAttribute,
            newToggleAttributeElements,
            newToggleFalseAttribute,
            newToggleFalseAttributeElements,
            newEvaljsElements;
        // every selected element will get a click event
        for (let i = 0; i < this.config.elements.length; i++) {
            let el = this.config.elements[i];
            el.addEventListener("click", (cEvent) => {
                let element = cEvent.target;
                // don't do anything when clicking on children
                if (el !== element) return;
                cEvent.preventDefault();
                /* classes which should be toggled */
                newToggleClass = element.dataset[this.config.toggleclass];
                /* classes which should be the toggle counterpart */
                newToggleFalseClass = element.dataset[this.config.togglefalseclass];
                /* classes which should be added */
                newAddClasses = element.dataset[this.config.addclasses];
                /* classes which should be removed */
                newDeleteClasses = element.dataset[this.config.deleteclasses];
                /* attributes which should be added */
                newAddAttribute = element.dataset[this.config.addattribute];
                /* attributes which should be removed */
                newDeleteAttribute = element.dataset[this.config.deleteattribute];
                /* attributes which should be toggled */
                newToggleAttribute = element.dataset[this.config.toggleattribute];
                /* attributes which should be the toggle counterpart */
                newToggleFalseAttribute = element.dataset[this.config.togglefalseattribute];
                /* eval js */
                newEvaljsElements = element.dataset[this.config.evaljs];

                /* toggle classes */
                if (newToggleClass) {
                    newToggleClassElements = newToggleClass.split(this.config.elementSplit);
                    if (newToggleFalseClass) {
                        newToggleFalseClassElements = newToggleFalseClass.split(this.config.elementSplit);
                        this.changeElementAttributes(newToggleClassElements, "toggleClass", newToggleFalseClassElements);
                    } else {
                        this.changeElementAttributes(newToggleClassElements, "toggleClass");
                    }
                }
                /* add classes */
                if (newAddClasses) {
                    newAddClassesElements = newAddClasses.split(this.config.elementSplit);
                    this.changeElementAttributes(newAddClassesElements, "addClass");
                }
                /* delete classes */
                if (newDeleteClasses) {
                    newDeleteClassesElements = newDeleteClasses.split(this.config.elementSplit);
                    this.changeElementAttributes(newDeleteClassesElements, "removeClass");
                }
                /* add attributes */
                if (newAddAttribute) {
                    newAddAttributeElements = newAddAttribute.split(this.config.elementSplit);
                    this.changeElementAttributes(newAddAttributeElements, "addAttr");
                }
                /* delete attributes */
                if (newDeleteAttribute) {
                    newDeleteAttributeElements = newDeleteAttribute.split(this.config.elementSplit);
                    this.changeElementAttributes(newDeleteAttributeElements, "removeAttr");
                }

                /* toggle attributes */
                if (newToggleAttribute) {
                    newToggleAttributeElements = newToggleAttribute.split(this.config.elementSplit);
                    if (newToggleFalseAttribute) {
                        newToggleFalseAttributeElements = newToggleFalseAttribute.split(this.config.elementSplit);
                        this.changeElementAttributes(newToggleAttributeElements, "toggleAttribute", newToggleFalseAttributeElements);
                    } else {
                        this.changeElementAttributes(newToggleAttributeElements, "toggleAttribute");
                    }
                }

                /* eval js */
                if (newEvaljsElements) {
                    this.changeElementAttributes(newEvaljsElements, "", "", this.currentClicked);
                }
            });
        }
    }

    /* makes the changes of every possibility */
    changeElementAttributes(elements, change, falseElements, currentClicked) {
        let selector,
            changeString,
            selectedElements = [],
            attribute,
            value;
        if (Array.isArray(elements)) {
            for (let index = 0; index < elements.length; index++) {
                let string = elements[index];
                /* string before | */
                selector = string.split(this.config.stringSplit).shift().trim();
                /* string after | */
                changeString = string.split(this.config.stringSplit).pop().trim();
                /* if changeString != selector, change selector before |  */
                if (selector != changeString) {
                    selectedElements = document.querySelectorAll(selector);
                } else {
                    selectedElements.push(this.config.parseContainer);
                }
                for (let i = 0; i < selectedElements.length; i++) {
                    let el = selectedElements[i];
                    /* toogle classes toggleclass and togglefalseclass on selector before | */
                    if (change == "toggleClass") {
                        if (!el.classList.contains(changeString)) {
                            el.classList.add(changeString);
                            if (falseElements) {
                                el.classList.remove(falseElements[index].split(this.config.stringSplit).pop());
                            }
                        } else {
                            el.classList.remove(changeString);
                            if (falseElements) {
                                el.classList.add(falseElements[index].split(this.config.stringSplit).pop());
                            }
                        }
                        /* adds all classes on parseContainer before | */
                    } else if (change == "addClass") {
                        if (Array.isArray(changeString)) {
                            el.classList.add(...changeString);
                        } else {
                            el.classList.add(changeString);
                        }
                        /* remove all attributes on parseContainer before | */
                    } else if (change == "removeClass") {
                        if (Array.isArray(changeString)) {
                            el.classList.remove(...changeString);
                        } else {
                            el.classList.remove(changeString);
                        }
                        /* add all attributes on parseContainer before | */
                    } else if (change == "addAttr") {
                        attribute = changeString.split("=").shift();
                        value = changeString.split("=").pop();
                        el.setAttribute(attribute, value);
                        /* remove attribut on parseContainer before | */
                    } else if (change == "removeAttr") {
                        el.removeAttribute(changeString);
                        /* toggle attribute on parseContainer before | */
                    } else if (change == "toggleAttribute") {
                        attribute = changeString.split(this.config.attrSplit).shift();
                        value = changeString.split(this.config.attrSplit).pop();
                        if (!el.getAttribute(attribute) || el.getAttribute(attribute) != value) {
                            el.setAttribute(attribute, value);
                            if (falseElements && el.getAttribute(attribute) != value) {
                                el.removeAttribute(falseElements[index].split(this.config.stringSplit).pop().split(this.config.attrSplit).shift());
                            }
                        } else {
                            el.removeAttribute(attribute);
                            if (falseElements) {
                                el.setAttribute(falseElements[index].split(this.config.stringSplit).pop().split(this.config.attrSplit).shift(), falseElements[index].split(this.config.stringSplit).pop().split(this.config.attrSplit).pop());
                            }
                        }
                    }
                }
            }
        } else {
            this.currentClicked = currentClicked;
            eval(elements);
        }
    }
}

let ig_togglehandler = document.getElementsByClassName("ig-togglehandler");
if (ig_togglehandler.length > 0) {
    new ToggleHandler({ elements: ig_togglehandler });
}
