var daterangeLocales = {
    'de-DE': {
        label : 'Daten auswählen',
        ranges: {
            'Letzte Woche': [moment().subtract(1, 'week'), moment()],
           	'Letzter Monat': [moment().subtract(1, 'month'), moment()],
           	'Letzte 3 Monate': [moment().subtract(3, 'month'), moment()],
           	'Letzte 6 Monate': [moment().subtract(6, 'month'), moment()],
           	'Letztes Jahr': [moment().subtract(1, 'year'), moment()]
        },
        locale: {
           "format": "DD. MMMM YYYY",
           "separator": " - ",
           "applyLabel": "Bestätigen",
           "cancelLabel": "Zurücksetzen",
           "fromLabel": "Von",
           "toLabel": "Bis",
           "customRangeLabel": "Benutzerdefiniert",
           "weekLabel": "W",
           "daysOfWeek": [
               "So",
               "Mo",
               "Di",
               "Mi",
               "Do",
               "Fr",
               "Sa"
           ],
           "monthNames": [
               "Januar",
               "Februar",
               "März",
               "April",
               "Mai",
               "Juni",
               "Juli",
               "August",
               "September",
               "Oktober",
               "November",
               "Dezember"
           ],
       }
    },
    'fr-FR': {
        label : 'Sélectionner des données',
        ranges: {
            'La semaine dernière': [moment().subtract(1, 'week'), moment()],
           	'Le mois dernier': [moment().subtract(1, 'month'), moment()],
           	'3 derniers mois': [moment().subtract(3, 'month'), moment()],
           	'6 derniers mois': [moment().subtract(6, 'month'), moment()],
           	'L\'année dernière': [moment().subtract(1, 'year'), moment()]
        },
        locale: {
           "format": "DD MMMM YYYY",
           "separator": " - ",
           "applyLabel": "Confirmer",
           "cancelLabel": "Réinitialiser par défaut",
           "fromLabel": "À partir de",
           "toLabel": "À",
           "customRangeLabel": "Personnalisé",
           "weekLabel": "W",
           "daysOfWeek": [
               "Di",
               "Lu",
               "Ma",
               "Me",
               "Je",
               "Ve",
               "Sa"
           ],
           "monthNames": [
               "Janvier",
               "Février",
               "Mars",
               "Avril",
               "Mai",
               "Juin",
               "Juillet",
               "Août",
               "Septembre",
               "Octobre",
               "Novembre",
               "Décembre"
           ],
       }
    },
    it: {
        label : 'Seleziona i dati',
        ranges: {
            'La scorsa settimana': [moment().subtract(1, 'week'), moment()],
           	'Lo scorso mese': [moment().subtract(1, 'month'), moment()],
           	'Ultimi 3 mesi': [moment().subtract(3, 'month'), moment()],
           	'Ultimi 6 mesi': [moment().subtract(6, 'month'), moment()],
           	'L\'anno scorso': [moment().subtract(1, 'year'), moment()]
        },
        locale: {
           "format": "DD.MM.YYYY",
           "separator": " - ",
           "applyLabel": "Confermare",
           "cancelLabel": "Riportare alle condizioni originali",
           "fromLabel": "A partire dal",
           "toLabel": "A",
           "customRangeLabel": "Costume",
           "weekLabel": "W",
           "daysOfWeek": [
               "Dom.",
               "Lun.",
               "Mar.",
               "Mer.",
               "Gio.",
               "Ver.",
               "Sab."
           ],
           "monthNames": [
               "Gennaio",
               "Febbraio",
               "Marzo",
               "Aprile",
               "Maggio",
               "Giugno",
               "Luglio",
               "Agosto",
               "Settembre",
               "Ottobre",
               "Novembre",
               "Dicembre"
           ],
       }
    },
    en: {
        label : 'Choose daterange',
        ranges: {
            'Last week': [moment().subtract(1, 'week'), moment()],
           	'Last month': [moment().subtract(1, 'month'), moment()],
           	'Last 3 months': [moment().subtract(3, 'month'), moment()],
           	'Last 6 months': [moment().subtract(6, 'month'), moment()],
           	'Last year': [moment().subtract(1, 'year'), moment()]
        },
        locale: {
           "format": "DD.MM.YYYY",
           "separator": " - ",
           "applyLabel": "Confirm",
           "cancelLabel": "Reset",
           "fromLabel": "From",
           "toLabel": "To",
           "customRangeLabel": "Custom",
           "weekLabel": "W",
           "daysOfWeek": [
               "Sun",
               "Mon",
               "Tue",
               "Wed",
               "Thu",
               "Fri",
               "Sat"
           ],
           "monthNames": [
               "January",
               "February",
               "March",
               "April",
               "May",
               "June",
               "July",
               "August",
               "September",
               "October",
               "November",
               "December"
           ],
       }
    }
};

daterangeLocales.de = daterangeLocales['de-DE'];
daterangeLocales.fr = daterangeLocales['fr-FR'];
