/* 
 * ausführbar mit (parameter ist content breakpoint):
 * if($('.sharedContent')){
 *  elementMover('650');
 * }
 */

function elementMover(matchMediaMaxWidth){
  // window width für alte browser fallback
  var windowWidth = $(window).width();
  // matchmedia funktion setzt listener auf css breite von funktions parameter
  if( typeof matchMedia!='undefined') {
    var mediaQuery=window.matchMedia("(max-width: "+matchMediaMaxWidth+"px)");
    // wird bei veränderungen mit funktion ausgefürt
    mediaQuery.addListener(widthChanged);
    // wird direkt einmal ausgeführt
    if(mediaQuery.matches==true) {
      moveElements();
    } else {
      moveElementsBack();
    }
  } else {
    // fallback auf smartresize für allte browser
    // legt browserweite fest
    windowWidth = $(window).width();
    // wird direkt einmal ausgeführt
    if(windowWidth < matchMediaMaxWidth) {
      moveElements();
    } else {
      moveElementsBack();
    }
    // wird dann per smartresize beim resizen ausgeführt
    $(window).smartresize(function() {
      windowWidth = $(window).width();
      if(windowWidth < matchMediaMaxWidth) {
        moveElements();
      } else {
        moveElementsBack();
      }
    });
  }
}
// funktion für listener. Entscheidet wann was ausgeführt wird
function widthChanged(mediaQuery) {
  if(mediaQuery.matches==true) {
    moveElements();
  } else {
    moveElementsBack();
  }
}
/* verschiebt elemente die so abgelegt sind:
 * <div class="original sharedContainer content-DATAROLLENANGABE">
 *   <div class="sharedContent" data-role="DATAROLLENANGABE">
 *    CONTENT DER VERSCHOBEN WERDEN SOLL
 *   </div>
 *  </div>
 * nach:
 * <div class="moved sharedContainer content-DATAROLLENANGABE"></div>
 */
function moveElementsBack() {
  $(".sharedContent").each(function() {
    $(".original.sharedContainer.content-"+$(this).attr("data-role")).append($(this));
  });
}
/* verschiebt elemente zurück von:
 * <div class="moved sharedContainer content-DATAROLLENANGABE">
 *  VERSCHOBENER CONTENT 
 * </div>
 * nach:
 * <div class="original sharedContainer content-DATAROLLENANGABE"></div>
 */
function moveElements() {
  $(".sharedContent").each(function() {
    $(".moved.sharedContainer.content-"+$(this).attr("data-role")).append($(this));
  });
}