/*
 *************************************
 * fancyinput.js
 * Fancy Elemente für Formular
 *************************************
 * @author    : internetgalerie
 *************************************
 * Chanchelog
 * FS | 05.01.2016 | Datei angelegt
 */
(function($) {
    $(document).ready(function() {
        $('.fancyInput').each(function() {
           $(this).children().first().children().first().addClass('fancyInput');
        });
        // resets the filds after loading
        resetIfEmpty();
        $(document).on('click focus change', '.fancyElement', function() {
            resetIfEmpty();
            $(this).parents('.fancyInput').addClass('clicked');
        });
        /* file actions start */
        $('.fancyFile button').click(function(e) {
            e.preventDefault();
            clickTarget = $(this).attr('data-click');
            $(clickTarget).click();
        });
        $('.fancyFile input').on('change', function() {
            $(this).parent().find('.inputPlaceholder').html($(this).val());
        });
	$('.fancyFile .inputPlaceholder').each(function() {
	    filename=$(this).parent().find('.fancyFileName').text();
	    val=filename ? filename : $(this).parent().find('input').val();
            $(this).html( val );
	    if( val) {
		$(this).parent().addClass('clicked');
	    }
	});
        /* file actions stop */

        // resets empty fields when a change, focus or click in a fancyElement
        function resetIfEmpty() {
            $('.fancyElement').each(function() {
                var $fancyInput = $(this).parents('.fancyInput');
                if ($(this).val() == '' && (typeof $(this).prop('placeholder') === 'undefined' || $(this).prop('placeholder').trim() === '')) {
                    $fancyInput.removeClass('clicked');
                } else {
                    $fancyInput.addClass('clicked');
                }

            	var $filename = $fancyInput.find('.fancyFileName');
            	if($filename.length > 0 && $filename.text() != '') {
                    $fancyInput.addClass('clicked');
            	}

                if($fancyInput.hasClass('fancyDate')) {
                    if($(this).data('value')!= '') {
			$fancyInput.addClass('clicked');
                    }
                }

            	if($fancyInput.hasClass('fancySelect')) {
            		var $firstOption = $(this).find('option:first');
            		if($firstOption.val() == '' && $firstOption.text() != '') {
                    	$fancyInput.addClass('clicked');
            		}
            	}
            });
        }

    });
})(jQuery);
